/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import java.util.Iterator;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Series;

public class IntervalPrice {
    private static final String UNKNOWN_PRICE_TYPE = "unknown price type";
    private double open;
    private double close;
    private double high;
    private double low;

    public IntervalPrice() {
        this(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public IntervalPrice(double open, double close, double high, double low) {
        this.setValues(open, close, high, low);
    }

    public double open() {
        return this.open;
    }

    public double close() {
        return this.close;
    }

    public double high() {
        return this.high;
    }

    public double low() {
        return this.low;
    }

    public double value(Type type) {
        switch (type) {
            case Open: {
                return this.open;
            }
            case Close: {
                return this.close;
            }
            case High: {
                return this.high;
            }
            case Low: {
                return this.low;
            }
        }
        throw new LibraryException(UNKNOWN_PRICE_TYPE);
    }

    public void setValue(Type type, double value) {
        switch (type) {
            case Open: {
                this.open = value;
                break;
            }
            case Close: {
                this.close = value;
                break;
            }
            case High: {
                this.high = value;
                break;
            }
            case Low: {
                this.low = value;
                break;
            }
            default: {
                throw new LibraryException(UNKNOWN_PRICE_TYPE);
            }
        }
    }

    public void setValues(double open, double close, double high, double low) {
        this.open = open;
        this.close = close;
        this.high = high;
        this.low = low;
    }

    public static <K> Series<K, IntervalPrice> makeSeries(Class<K> classK, K[] date, double[] open, double[] close, double[] high, double[] low) {
        int dsize = date.length;
        if (open.length != dsize || close.length != dsize || high.length != dsize || low.length != dsize) {
            throw new LibraryException("array sizes mismatch");
        }
        Series<K, IntervalPrice> retval = new Series<K, IntervalPrice>(classK, IntervalPrice.class);
        for (int i = 0; i < dsize; ++i) {
            retval.put(date[i], new IntervalPrice(open[i], close[i], high[i], low[i]));
        }
        return retval;
    }

    public static <K> double[] extractValues(Series<K, IntervalPrice> ts, Type type) {
        double[] result = new double[ts.size()];
        Iterator<IntervalPrice> it = ts.values().iterator();
        for (int i = 0; i < ts.size(); ++i) {
            result[i] = it.next().value(type);
        }
        return result;
    }

    public static <K> Series<K, Double> extractComponent(Class<K> classK, Series<K, IntervalPrice> ts, Type type) {
        Series<K, Double> result = new Series<K, Double>(classK, Double.class);
        for (K date : ts.keySet()) {
            IntervalPrice prices = ts.get(date);
            result.put(date, prices.value(type));
        }
        return result;
    }

    public static enum Type {
        Open,
        Close,
        High,
        Low;

    }
}

