/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;

public abstract class AbstractSolver1D<F extends Ops.DoubleOp> {
    private static final int MAX_FUNCTION_EVALUATIONS = 100;
    private int maxEvaluations;
    private boolean lowerBoundEnforced;
    private boolean upperBoundEnforced;
    protected double root;
    protected double xMin;
    protected double xMax;
    protected double fxMin;
    protected double fxMax;
    protected int evaluationNumber;
    protected double lowerBound;
    protected double upperBound;

    public AbstractSolver1D() {
        this.maxEvaluations = 100;
        this.lowerBoundEnforced = false;
        this.upperBoundEnforced = false;
    }

    public AbstractSolver1D(int maxEvalautions, boolean lowerBoundEnforced, boolean upperBoundenforeced) {
        this.setMaxEvaluations(maxEvalautions);
        this.lowerBoundEnforced = lowerBoundEnforced;
        this.upperBoundEnforced = upperBoundenforeced;
    }

    protected abstract double solveImpl(F var1, double var2);

    public double solve(F f, double accuracy, double guess, double step) {
        QL.require(accuracy > 0.0, "accuracy must be positive");
        accuracy = Math.max(accuracy, Constants.QL_EPSILON);
        double growthFactor = 1.6;
        int flipflop = -1;
        this.root = guess;
        this.fxMax = f.op(this.root);
        if (this.fxMax == 0.0) {
            return this.root;
        }
        if (this.fxMax > 0.0) {
            this.xMin = this.enforceBounds(this.root - step);
            this.fxMin = f.op(this.xMin);
            this.xMax = this.root;
        } else {
            this.xMin = this.root;
            this.fxMin = this.fxMax;
            this.xMax = this.enforceBounds(this.root + step);
            this.fxMax = f.op(this.xMax);
        }
        this.evaluationNumber = 2;
        while (this.evaluationNumber <= this.maxEvaluations) {
            if (this.fxMin * this.fxMax <= 0.0) {
                if (this.fxMin == 0.0) {
                    return this.xMin;
                }
                if (this.fxMax == 0.0) {
                    return this.xMax;
                }
                this.root = (this.xMax + this.xMin) / 2.0;
                return this.solveImpl(f, accuracy);
            }
            if (Math.abs(this.fxMin) < Math.abs(this.fxMax)) {
                this.xMin = this.enforceBounds(this.xMin + 1.6 * (this.xMin - this.xMax));
                this.fxMin = f.op(this.xMin);
            } else if (Math.abs(this.fxMin) > Math.abs(this.fxMax)) {
                this.xMax = this.enforceBounds(this.xMax + 1.6 * (this.xMax - this.xMin));
                this.fxMax = f.op(this.xMax);
            } else if (flipflop == -1) {
                this.xMin = this.enforceBounds(this.xMin + 1.6 * (this.xMin - this.xMax));
                this.fxMin = f.op(this.xMin);
                ++this.evaluationNumber;
                flipflop = 1;
            } else if (flipflop == 1) {
                this.xMax = this.enforceBounds(this.xMax + 1.6 * (this.xMax - this.xMin));
                this.fxMax = f.op(this.xMax);
                flipflop = -1;
            }
            ++this.evaluationNumber;
        }
        throw new ArithmeticException("unable to bracket root after function evaluation");
    }

    public double solve(F f, double accuracy, double guess, double xMin, double xMax) {
        QL.require(accuracy > 0.0, "accuracy must be positive");
        QL.require(xMin < xMax, "invalid range: xMin >= xMax");
        QL.require(!this.lowerBoundEnforced || xMin >= this.lowerBound, "xMin < enforced low bound");
        QL.require(!this.upperBoundEnforced || xMax <= this.upperBound, "xMax > enforced hi bound");
        accuracy = Math.max(accuracy, Constants.QL_EPSILON);
        this.xMin = xMin;
        this.xMax = xMax;
        this.fxMin = f.op(this.xMin);
        if (this.fxMin == 0.0) {
            return this.xMin;
        }
        this.fxMax = f.op(this.xMax);
        if (this.fxMax == 0.0) {
            return this.xMax;
        }
        this.evaluationNumber = 2;
        QL.require(this.fxMin * this.fxMax < 0.0, "root not bracketed");
        QL.require(guess > this.xMin, "guess must be greather than xMin");
        QL.require(guess < this.xMax, "guess must be lesser than xMax");
        this.root = guess;
        return this.solveImpl(f, accuracy);
    }

    public void setMaxEvaluations(int evaluations) {
        this.maxEvaluations = Math.max(1, evaluations);
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
        this.lowerBoundEnforced = true;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
        this.upperBoundEnforced = true;
    }

    public int getNumEvaluations() {
        return this.evaluationNumber;
    }

    private double enforceBounds(double x) {
        if (this.lowerBoundEnforced && x < this.lowerBound) {
            return this.lowerBound;
        }
        if (this.upperBoundEnforced && x > this.upperBound) {
            return this.upperBound;
        }
        return x;
    }
}

