/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.legacy.libormarkets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jquantlib.legacy.libormarkets.LmVolatilityModel;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;

public abstract class LmLinearExponentialVolatilityModel
extends LmVolatilityModel {
    private final List<Double> fixingTimes_;

    public LmLinearExponentialVolatilityModel(List<Double> fixingTimes, double a, double b, double c, double d) {
        super(fixingTimes.size(), 4);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.fixingTimes_ = fixingTimes;
        this.arguments_.set(0, new ConstantParameter(a, new PositiveConstraint()));
        this.arguments_.set(1, new ConstantParameter(b, new PositiveConstraint()));
        this.arguments_.set(2, new ConstantParameter(c, new PositiveConstraint()));
        this.arguments_.set(3, new ConstantParameter(d, new PositiveConstraint()));
    }

    public List<Double> volatility(double t, List list) {
        double a = ((Parameter)this.arguments_.get(0)).get(0.0);
        double b = ((Parameter)this.arguments_.get(1)).get(0.0);
        double c = ((Parameter)this.arguments_.get(2)).get(0.0);
        double d = ((Parameter)this.arguments_.get(3)).get(0.0);
        ArrayList<Double> tmp = new ArrayList<Double>(this.size_);
        Collections.fill(tmp, 0.0);
        for (int i = 0; i < this.size_; ++i) {
            double T = this.fixingTimes_.get(i);
            if (!(T > t)) continue;
            tmp.set(i, (a * (T - t) + d) * Math.exp(-b * (T - t)) + c);
        }
        return tmp;
    }

    public double volatility(int i, double t, List list) {
        double a = ((Parameter)this.arguments_.get(0)).get(0.0);
        double b = ((Parameter)this.arguments_.get(1)).get(0.0);
        double c = ((Parameter)this.arguments_.get(2)).get(0.0);
        double d = ((Parameter)this.arguments_.get(3)).get(0.0);
        double T = this.fixingTimes_.get(i);
        return T > t ? (a * (T - t) + d) * Math.exp(-b * (T - t)) + c : 0.0;
    }

    public double integratedVariance(int i, int j, double u, List list) {
        double a = ((Parameter)this.arguments_.get(0)).get(0.0);
        double b = ((Parameter)this.arguments_.get(1)).get(0.0);
        double c = ((Parameter)this.arguments_.get(2)).get(0.0);
        double d = ((Parameter)this.arguments_.get(3)).get(0.0);
        double T = this.fixingTimes_.get(i);
        double S = this.fixingTimes_.get(j);
        double k1 = Math.exp(b * u);
        double k2 = Math.exp(b * S);
        double k3 = Math.exp(b * T);
        return (a * a * (-1.0 - 2.0 * b * b * S * T - b * (S + T) + k1 * k1 * (1.0 + b * (S + T - 2.0 * u) + 2.0 * b * b * (S - u) * (T - u))) + 2.0 * b * b * (2.0 * c * d * (k2 + k3) * (k1 - 1.0) + d * d * (k1 * k1 - 1.0) + 2.0 * b * c * c * k2 * k3 * u) + 2.0 * a * b * (d * (-1.0 - b * (S + T) + k1 * k1 * (1.0 + b * (S + T - 2.0 * u))) - 2.0 * c * (k3 * (1.0 + b * S) + k2 * (1.0 + b * T) - k1 * k3 * (1.0 + b * (S - u)) - k1 * k2 * (1.0 + b * (T - u))))) / (4.0 * b * b * b * k2 * k3);
    }

    @Override
    public void generateArguments() {
    }
}

