/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.legacy.libormarkets;

import org.jquantlib.QL;
import org.jquantlib.legacy.libormarkets.LmVolatilityModel;
import org.jquantlib.math.matrixutilities.Array;

public class LmFixedVolatilityModel
extends LmVolatilityModel {
    private final Array volatilities_;
    private final Array startTimes_;

    public LmFixedVolatilityModel(Array volatilities, Array startTimes) {
        super(startTimes.size(), 0);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.volatilities_ = volatilities;
        this.startTimes_ = startTimes;
        QL.require(this.startTimes_.size() > 1, "too few dates");
        QL.require(this.volatilities_.size() == this.startTimes_.size(), "volatility array and fixing time array have to have the same size");
        for (int i = 1; i < this.startTimes_.size(); ++i) {
            if (!(this.startTimes_.get(i) <= this.startTimes_.get(i - 1))) continue;
            throw new IllegalArgumentException("invalid time (" + this.startTimes_.get(i) + ", vs " + this.startTimes_.get(i) + ")");
        }
    }

    @Override
    protected void generateArguments() {
    }

    @Override
    public Array volatility(double t, Array x) {
        QL.require(t < this.startTimes_.first() || t > this.startTimes_.last(), "invalid time given for volatility model");
        int ti = (int)((double)this.startTimes_.upperBound(t) - this.startTimes_.first() - 1.0);
        Array tmp = new Array(this.size_);
        for (int i = ti; i < this.size_; ++i) {
            tmp.set(i, this.volatilities_.get(i - ti));
        }
        Array ret = new Array(tmp.size());
        for (int i = 0; i < tmp.size(); ++i) {
            ret.set(i, tmp.get(i));
        }
        return ret;
    }

    @Override
    public double volatility(int i, double t, Array x) {
        if (t < this.startTimes_.first() || t > this.startTimes_.last()) {
            throw new IllegalArgumentException("invalid time given for volatility model");
        }
        int ti = (int)((double)this.startTimes_.upperBound(t) - this.startTimes_.first() - 1.0);
        return this.volatilities_.get(i - ti);
    }
}

