/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.legacy.libormarkets;

import org.jquantlib.QL;
import org.jquantlib.legacy.libormarkets.LmCorrelationModel;
import org.jquantlib.legacy.libormarkets.LmVolatilityModel;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.GaussKronrodAdaptive;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.processes.LfmCovarianceParameterization;

public class LfmCovarianceProxy
extends LfmCovarianceParameterization {
    protected LmVolatilityModel volaModel_;
    protected LmCorrelationModel corrModel_;

    public LfmCovarianceProxy(LmVolatilityModel volaModel, LmCorrelationModel corrModel) {
        super(corrModel.size(), corrModel.factors());
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.volaModel_ = volaModel;
        this.corrModel_ = corrModel;
    }

    public LmVolatilityModel volatilityModel() {
        return this.volaModel_;
    }

    public LmCorrelationModel correlationModel() {
        return this.corrModel_;
    }

    @Override
    public Matrix diffusion(double t, Array x) {
        Matrix pca = this.corrModel_.pseudoSqrt(t, x);
        Array vol = this.volaModel_.volatility(t, x);
        for (int i = 0; i < this.size_; ++i) {
            pca.rangeRow(i).mulAssign(vol.get(i));
        }
        return pca;
    }

    @Override
    public Matrix covariance(double t, Array x) {
        Array volatility = this.volaModel_.volatility(t, x);
        Matrix correlation = this.corrModel_.correlation(t, x);
        Matrix tmp = new Matrix(this.size_, this.size_);
        for (int i = 0; i < this.size_; ++i) {
            for (int j = 0; j < this.size_; ++j) {
                tmp.set(i, j, volatility.get(i) * correlation.get(i, j) * volatility.get(j));
            }
        }
        return tmp;
    }

    public double integratedCovariance(int i, int j, double t, Array x) {
        if (this.corrModel_.isTimeIndependent()) {
            try {
                return this.corrModel_.correlation(i, j, 0.0, x) * this.volaModel_.integratedVariance(j, i, t, x);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        QL.require(!x.empty(), "can not handle given x here");
        double tmp = 0.0;
        Var_Helper helper = new Var_Helper(this, i, j);
        GaussKronrodAdaptive integrator = new GaussKronrodAdaptive(1.0E-10, 10000);
        for (int k = 0; k < 64; ++k) {
            tmp += integrator.op(helper, (double)k * t / 64.0, (double)(k + 1) * t / 64.0);
        }
        return tmp;
    }

    static class Var_Helper
    implements Ops.DoubleOp {
        private final int i_;
        private final int j_;
        private final LmVolatilityModel volaModel_;
        private final LmCorrelationModel corrModel_;

        public Var_Helper(LfmCovarianceProxy proxy, int i, int j) {
            this.i_ = i;
            this.j_ = j;
            this.volaModel_ = proxy.volaModel_;
            this.corrModel_ = proxy.corrModel_;
        }

        @Override
        public double op(double t) {
            double v1;
            double v2;
            if (this.i_ == this.j_) {
                v1 = v2 = this.volaModel_.volatility(this.i_, t);
            } else {
                v1 = this.volaModel_.volatility(this.i_, t);
                v2 = this.volaModel_.volatility(this.j_, t);
            }
            return v1 * this.corrModel_.correlation(this.i_, this.j_, t) * v2;
        }
    }
}

