/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.lang.iterators;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Iterables {
    public static <T> Iterable<T> unmodifiableIterable(Enumeration<T> en) {
        return new IterableEnumeration(en);
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterator<T> it) {
        return new IterableIterator(it);
    }

    public static <T> Iterable<T> unmodifiableIterable(List<T> list) {
        return new IterableIterator(list.iterator());
    }

    public static <T> Iterable<T> unmodifiableIterable(Set<T> set) {
        return new IterableIterator(set.iterator());
    }

    private static class IterableIterator<T>
    implements Iterable<T> {
        private final Iterator<T> it;

        private IterableIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return IterableIterator.this.it.hasNext();
                }

                @Override
                public T next() {
                    return IterableIterator.this.it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class IterableEnumeration<T>
    implements Iterable<T> {
        private final Enumeration<T> en;

        private IterableEnumeration(Enumeration<T> en) {
            this.en = en;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return IterableEnumeration.this.en.hasMoreElements();
                }

                @Override
                public T next() {
                    return IterableEnumeration.this.en.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

