/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import org.jquantlib.QL;
import org.jquantlib.cashflow.FixedRateLeg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.Bond;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;

public class FixedRateBond
extends Bond {
    protected Frequency frequency_;
    protected DayCounter dayCounter_;

    public FixedRateBond(int settlementDays, double faceAmount, Schedule schedule, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention paymentConvention, double redemption, Date issueDate) {
        super(settlementDays, schedule.calendar(), issueDate);
        this.frequency_ = schedule.tenor().frequency();
        this.dayCounter_ = accrualDayCounter;
        this.maturityDate_ = schedule.endDate().clone();
        this.cashflows_ = new FixedRateLeg(schedule, accrualDayCounter).withNotionals(faceAmount).withCouponRates(coupons).withPaymentAdjustment(paymentConvention).Leg();
        this.addRedemptionsToCashflows(new double[]{redemption});
        QL.ensure(!this.cashflows().isEmpty(), "bond with no cashflows!");
        QL.ensure(this.redemptions_.size() == 1, "multiple redemptions created");
    }

    public FixedRateBond(int settlementDays, double faceAmount, Schedule schedule, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention paymentConvention, double redemption) {
        this(settlementDays, faceAmount, schedule, coupons, accrualDayCounter, paymentConvention, redemption, new Date());
    }

    public FixedRateBond(int settlementDays, double faceAmount, Schedule schedule, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention paymentConvention) {
        this(settlementDays, faceAmount, schedule, coupons, accrualDayCounter, paymentConvention, 100.0, new Date());
    }

    public FixedRateBond(int settlementDays, double faceAmount, Schedule schedule, double[] coupons, DayCounter accrualDayCounter) {
        this(settlementDays, faceAmount, schedule, coupons, accrualDayCounter, BusinessDayConvention.Following, 100.0, new Date());
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention, double redemption, Date issueDate, Date stubDate, DateGeneration.Rule rule, boolean endOfMonth) {
        super(settlementDays, calendar, issueDate);
        this.frequency_ = tenor.frequency();
        this.dayCounter_ = accrualDayCounter;
        this.maturityDate_ = maturityDate.clone();
        Date firstDate = new Date();
        Date nextToLastDate = new Date();
        switch (rule) {
            case Backward: {
                firstDate = new Date();
                nextToLastDate = stubDate.clone();
                break;
            }
            case Forward: {
                firstDate = stubDate.clone();
                nextToLastDate = new Date();
                break;
            }
            case Zero: 
            case ThirdWednesday: 
            case Twentieth: 
            case TwentiethIMM: {
                throw new LibraryException(this.reportFalseDateGenerationRule(stubDate, rule));
            }
            default: {
                throw new LibraryException("unknown DateGeneration.Rule");
            }
        }
        Schedule schedule = new Schedule(startDate, this.maturityDate_, tenor, this.calendar_, accrualConvention, accrualConvention, rule, endOfMonth, firstDate, nextToLastDate);
        this.cashflows_ = new FixedRateLeg(schedule, accrualDayCounter).withNotionals(faceAmount).withCouponRates(coupons).withPaymentAdjustment(paymentConvention);
        this.addRedemptionsToCashflows(new double[]{redemption});
        QL.ensure(!this.cashflows().isEmpty(), "bond with no cashflows!");
        QL.ensure(this.redemptions_.size() == 1, "multiple redemptions created");
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention, double redemption, Date issueDate, Date stubDate, DateGeneration.Rule rule) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, accrualConvention, paymentConvention, redemption, issueDate, stubDate, rule, false);
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention, double redemption, Date issueDate, Date stubDate) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, accrualConvention, paymentConvention, redemption, issueDate, stubDate, DateGeneration.Rule.Backward, false);
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention, double redemption, Date issueDate) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, accrualConvention, paymentConvention, redemption, issueDate, new Date(), DateGeneration.Rule.Backward, false);
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention, double redemption) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, accrualConvention, paymentConvention, redemption, new Date(), new Date(), DateGeneration.Rule.Backward, false);
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, accrualConvention, paymentConvention, 100.0, new Date(), new Date(), DateGeneration.Rule.Backward, false);
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, accrualConvention, BusinessDayConvention.Following, 100.0, new Date(), new Date(), DateGeneration.Rule.Backward, false);
    }

    public FixedRateBond(int settlementDays, Calendar calendar, double faceAmount, Date startDate, Date maturityDate, Period tenor, double[] coupons, DayCounter accrualDayCounter) {
        this(settlementDays, calendar, faceAmount, startDate, maturityDate, tenor, coupons, accrualDayCounter, BusinessDayConvention.Following, BusinessDayConvention.Following, 100.0, new Date(), new Date(), DateGeneration.Rule.Backward, false);
    }

    public Frequency frequency() {
        return this.frequency_;
    }

    public DayCounter dayCounter() {
        return this.dayCounter_;
    }

    private String reportFalseDateGenerationRule(Date stubDate, DateGeneration.Rule rule) {
        StringBuilder sb = new StringBuilder();
        sb.append("stub date (").append(stubDate).append(") not allowed with DateGeneration.Rule (").append((Object)rule).append(")");
        return sb.toString();
    }
}

