/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class GapPayoff
extends StrikedTypePayoff {
    protected double secondStrike;

    public GapPayoff(Option.Type type, double strike, double secondStrike) {
        super(type, strike);
        this.secondStrike = secondStrike;
    }

    public double getSecondStrike() {
        return this.secondStrike;
    }

    @Override
    public String name() {
        return "Gap";
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.description()).append(", ").append(this.secondStrike).append(" second strike");
        return sb.toString();
    }

    @Override
    public final double get(double price) {
        if (this.type == Option.Type.Call) {
            return price - this.strike >= 0.0 ? price - this.secondStrike : 0.0;
        }
        if (this.type == Option.Type.Put) {
            return this.strike - price >= 0.0 ? this.secondStrike - price : 0.0;
        }
        throw new LibraryException("unknown option type");
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

