/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;

public class ContinuousAveragingAsianOption
extends OneAssetOption {
    protected AverageType averageType;

    public ContinuousAveragingAsianOption(AverageType averageType, StrikedTypePayoff payoff, Exercise exercise) {
        super(payoff, exercise);
        this.averageType = averageType;
    }

    @Override
    public void setupArguments(PricingEngine.Arguments arguments) {
        super.setupArguments(arguments);
        QL.require(OneAssetOption.Arguments.class.isAssignableFrom(arguments.getClass()), "Unexpected type for type parameter");
        ArgumentsImpl a = (ArgumentsImpl)arguments;
        a.averageType = this.averageType;
    }

    public static abstract class EngineImpl
    extends GenericEngine<ArgumentsImpl, ResultsImpl>
    implements OneAssetOption.Results {
        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }
    }

    public static class ResultsImpl
    extends OneAssetOption.ResultsImpl
    implements OneAssetOption.Results {
    }

    public static class ArgumentsImpl
    extends OneAssetOption.ArgumentsImpl
    implements OneAssetOption.Arguments {
        private static final String UNSPECIFIED_AVERAGE_TYPE = "unspecified average type";
        public AverageType averageType;

        @Override
        public void validate() {
            super.validate();
            QL.require(this.averageType != null, UNSPECIFIED_AVERAGE_TYPE);
        }
    }
}

