/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class AssetOrNothingPayoff
extends StrikedTypePayoff {
    public AssetOrNothingPayoff(Option.Type type, double strike) {
        super(type, strike);
    }

    @Override
    public String name() {
        return "AssetOrNothing";
    }

    @Override
    public final double get(double price) {
        if (this.type == Option.Type.Call) {
            return price - this.strike > 0.0 ? price : 0.0;
        }
        if (this.type == Option.Type.Put) {
            return this.strike - price > 0.0 ? price : 0.0;
        }
        throw new LibraryException("unknown/illegal option type");
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

