/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes.ibor;

import org.jquantlib.QL;
import org.jquantlib.currencies.Currency;
import org.jquantlib.currencies.Europe;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.JointCalendar;
import org.jquantlib.time.calendars.UnitedKingdom;

public class Libor
extends IborIndex {
    private final Calendar financialCenterCalendar;
    private final Calendar jointCalendar;

    public Libor(String familyName, Period tenor, int settlementDays, Currency currency, Calendar financialCenterCalendar, DayCounter dayCounter, Handle<YieldTermStructure> h) {
        super(familyName, tenor, settlementDays, currency, new UnitedKingdom(UnitedKingdom.Market.Exchange), Libor.liborConvention(tenor), Libor.liborEOM(tenor), dayCounter, h);
        this.financialCenterCalendar = financialCenterCalendar;
        this.jointCalendar = new JointCalendar((Calendar)new UnitedKingdom(UnitedKingdom.Market.Exchange), financialCenterCalendar, JointCalendar.JointCalendarRule.JoinHolidays);
        QL.require(this.tenor().units() != TimeUnit.Days, "for daily tenors (" + this.tenor() + ") dedicated DailyTenor constructor must be used");
        QL.require(!currency.eq(new Europe.EURCurrency()), "for EUR Libor dedicated EurLibor constructor must be used");
    }

    public Libor(String familyName, Period tenor, int settlementDays, Currency currency, Calendar financialCenterCalendar, DayCounter dayCounter) {
        this(familyName, tenor, settlementDays, currency, financialCenterCalendar, dayCounter, new Handle<YieldTermStructure>());
    }

    @Override
    public Date valueDate(Date fixingDate) {
        QL.require(this.isValidFixingDate(fixingDate), "Fixing date " + fixingDate + " is not valid");
        Date d = this.fixingCalendar().advance(fixingDate, this.fixingDays(), TimeUnit.Days);
        return this.jointCalendar.adjust(d);
    }

    @Override
    public Date maturityDate(Date valueDate) {
        return this.jointCalendar.advance(valueDate, this.tenor(), this.businessDayConvention(), this.endOfMonth());
    }

    @Override
    public Handle<IborIndex> clone(Handle<YieldTermStructure> h) {
        return new Handle<IborIndex>(new Libor(this.familyName(), this.tenor(), this.fixingDays(), this.currency(), this.financialCenterCalendar, this.dayCounter(), h));
    }
}

