/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.currencies.Currency;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.indexes.InflationIndex;
import org.jquantlib.indexes.Region;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.InflationTermStructure;
import org.jquantlib.termstructures.YoYInflationTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Pair;

public abstract class YoYInflationIndex
extends InflationIndex {
    private Handle<YoYInflationTermStructure> yoyInflation;
    private boolean ratio;

    public YoYInflationIndex(String familyName, Region region, boolean revised, boolean interpolated, boolean ratio, Frequency frequency, Period availabilityLag, Currency currency) {
        this(familyName, region, revised, interpolated, ratio, frequency, availabilityLag, currency, new Handle<YoYInflationTermStructure>());
    }

    public YoYInflationIndex(String familyName, Region region, boolean revised, boolean interpolated, boolean ratio, Frequency frequency, Period availabilityLag, Currency currency, Handle<YoYInflationTermStructure> yoyInflation) {
        super(familyName, region, revised, interpolated, frequency, availabilityLag, currency);
        this.ratio = ratio;
        this.yoyInflation = yoyInflation;
        this.yoyInflation.addObserver(this);
    }

    @Override
    public double fixing(Date fixingDate) {
        return this.fixing(fixingDate, false);
    }

    @Override
    public double fixing(Date fixingDate, boolean forecastTodaysFixing) {
        Date today = new Settings().evaluationDate();
        Date todayMinusLag = today.sub(this.availabilityLag);
        Pair<Date, Date> lim = InflationTermStructure.inflationPeriod(todayMinusLag, this.frequency);
        if (fixingDate.lt(todayMinusLag = lim.second().inc()) || fixingDate.eq(todayMinusLag) && !forecastTodaysFixing) {
            double pastFixing = (Double)IndexManager.getInstance().getHistory(this.name()).get(fixingDate);
            QL.require(!Double.isNaN(pastFixing), "Missing " + this.name() + " fixing for " + fixingDate);
            Date previousDate = fixingDate.sub(new Period(1, TimeUnit.Years));
            double previousFixing = (Double)IndexManager.getInstance().getHistory(this.name()).get(previousDate);
            QL.require(!Double.isNaN(pastFixing), "Missing " + this.name() + " fixing for " + previousFixing);
            return pastFixing / previousFixing - 1.0;
        }
        return this.forecastFixing(fixingDate);
    }

    public Handle<YoYInflationTermStructure> yoyInflationTermStructure() {
        return this.yoyInflation;
    }

    public boolean ratio() {
        return this.ratio;
    }

    private double forecastFixing(Date fixingDate) {
        Date d = fixingDate;
        if (!this.interpolated()) {
            Pair<Date, Date> lim = InflationTermStructure.inflationPeriod(fixingDate, this.frequency);
            int n = (int)lim.second().sub(lim.first()) / 2;
            d = lim.first().add(n);
        }
        return this.yoyInflation.currentLink().yoyRate(d);
    }
}

