/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import java.util.ArrayList;
import org.jquantlib.Settings;
import org.jquantlib.currencies.Currency;
import org.jquantlib.indexes.Index;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.indexes.Region;
import org.jquantlib.lang.annotation.Real;
import org.jquantlib.termstructures.InflationTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Observer;
import org.jquantlib.util.Pair;

public abstract class InflationIndex
extends Index
implements Observer {
    protected String familyName;
    protected Region region;
    protected boolean revised;
    protected boolean interpolated;
    protected Frequency frequency;
    protected Period availabilityLag;
    protected Currency currency;

    public InflationIndex(String familyName, Region region, boolean revised, boolean interpolated, Frequency frequency, Period availabilityLag, Currency currency) {
        this.familyName = familyName;
        this.region = region;
        this.revised = revised;
        this.interpolated = interpolated;
        this.availabilityLag = availabilityLag;
        this.currency = currency;
        new Settings().evaluationDate().addObserver(this);
        IndexManager.getInstance().notifier(this.name()).addObserver(this);
    }

    @Override
    public String name() {
        StringBuilder builder = new StringBuilder(this.region.name());
        builder.append(" ");
        builder.append(this.familyName);
        return builder.toString();
    }

    @Override
    public Calendar fixingCalendar() {
        return new NullCalendar();
    }

    @Override
    public boolean isValidFixingDate(Date fixingDate) {
        return true;
    }

    public String familyName() {
        return this.familyName;
    }

    public Region region() {
        return this.region;
    }

    public boolean revised() {
        return this.revised;
    }

    public boolean interpolated() {
        return this.interpolated;
    }

    public Frequency frequency() {
        return this.frequency;
    }

    public Period availabilityLag() {
        return this.availabilityLag;
    }

    public Currency currency() {
        return this.currency;
    }

    @Override
    public void addFixing(Date fixingDate, @Real double fixing, boolean forceOverwrite) {
        Pair<Date, Date> lim = InflationTermStructure.inflationPeriod(fixingDate, this.frequency);
        int n = (int)lim.second().inc().sub(lim.first());
        ArrayList<Date> dates = new ArrayList<Date>();
        ArrayList<Double> rates = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            dates.add(i, lim.first().add(i));
            rates.add(i, fixing);
        }
        super.addFixings(dates.iterator(), rates.iterator(), forceOverwrite);
    }

    @Override
    public void update() {
        this.notifyObservers();
    }
}

