/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.QL;
import org.jquantlib.currencies.Europe;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.JointCalendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.time.calendars.UnitedKingdom;

public class EURLibor
extends IborIndex {
    private Calendar target;

    public EURLibor(Period tenor) {
        this(tenor, new Handle<YieldTermStructure>());
    }

    public EURLibor(Period tenor, Handle<YieldTermStructure> h) {
        super("EURLibor", tenor, 2, new Europe.EURCurrency(), new JointCalendar((Calendar)new UnitedKingdom(UnitedKingdom.Market.Exchange), (Calendar)new Target(), JointCalendar.JointCalendarRule.JoinBusinessDays), EURLibor.eurliborConvention(tenor), EURLibor.eurliborEOM(tenor), new Actual360(), h);
        QL.require(this.tenor().units() != TimeUnit.Days, "for daily tenors dedicated DailyTenor constructor must be used");
        this.target = new Target();
    }

    @Override
    public Date valueDate(Date fixingDate) {
        QL.require(this.isValidFixingDate(fixingDate), "Fixing date " + fixingDate + " is not valid");
        return this.target.advance(fixingDate, this.fixingDays, TimeUnit.Days);
    }

    @Override
    public Date maturityDate(Date valueDate) {
        return this.target.advance(valueDate, this.tenor(), this.businessDayConvention(), this.endOfMonth());
    }
}

