/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.QL;
import org.jquantlib.experimental.lattices.ExtendedEqualJumpsBinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class ExtendedTrigeorgis
extends ExtendedEqualJumpsBinomialTree {
    public ExtendedTrigeorgis(StochasticProcess1D process, double end, int steps, double strike) {
        super(process, end, steps);
        this.dx = Math.sqrt(process.variance(0.0, this.x0, this.dt) + this.driftStep(0.0) * this.driftStep(0.0));
        this.pu = 0.5 + 0.5 * this.driftStep(0.0) / this.dxStep(0.0);
        this.pd = 1.0 - this.pu;
        QL.require(this.pu <= 1.0, "negative probability");
        QL.require(this.pu >= 0.0, "negative probability");
    }

    @Override
    protected double dxStep(double stepTime) {
        return Math.sqrt(this.treeProcess.variance(stepTime, this.x0, this.dt) + this.driftStep(stepTime) * this.driftStep(stepTime));
    }

    @Override
    protected double probUp(double stepTime) {
        return 0.5 + 0.5 * this.driftStep(stepTime) / this.dxStep(stepTime);
    }
}

