/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.QL;
import org.jquantlib.experimental.lattices.ExtendedBinomialTree;
import org.jquantlib.math.distributions.BinomialDistribution;
import org.jquantlib.processes.StochasticProcess1D;

public class ExtendedLeisenReimer
extends ExtendedBinomialTree {
    private final double end;
    private final int oddSteps;
    private final double strike;
    private final double up;
    private final double down;
    private final double pu;
    private final double pd;

    public ExtendedLeisenReimer(StochasticProcess1D process, double end, int steps, double strike) {
        super(process, end, steps % 2 != 0 ? steps : steps + 1);
        this.end = end;
        this.oddSteps = steps % 2 != 0 ? steps : steps + 1;
        this.strike = strike;
        QL.require(strike > 0.0, "strike must be positive");
        double variance = process.variance(0.0, this.x0, end);
        double ermqdt = Math.exp(this.driftStep(0.0) + 0.5 * variance / (double)this.oddSteps);
        double d2 = (Math.log(this.x0 / strike) + this.driftStep(0.0) * (double)this.oddSteps) / Math.sqrt(variance);
        this.pu = BinomialDistribution.PeizerPrattMethod2Inversion(d2, this.oddSteps);
        this.pd = 1.0 - this.pu;
        double pdash = BinomialDistribution.PeizerPrattMethod2Inversion(d2 + Math.sqrt(variance), this.oddSteps);
        this.up = ermqdt * pdash / this.pu;
        this.down = (ermqdt - this.pu * this.up) / (1.0 - this.pu);
        QL.require(this.pu <= 1.0, "negative probability");
        QL.require(this.pu >= 0.0, "negative probability");
    }

    @Override
    public double underlying(int i, int index) {
        double stepTime = (double)i * this.dt;
        double variance = this.treeProcess.variance(stepTime, this.x0, this.end);
        double ermqdt = Math.exp(this.driftStep(stepTime) + 0.5 * variance / (double)this.oddSteps);
        double d2 = (Math.log(this.x0 / this.strike) + this.driftStep(stepTime) * (double)this.oddSteps) / Math.sqrt(variance);
        double pu = BinomialDistribution.PeizerPrattMethod2Inversion(d2, this.oddSteps);
        double pdash = BinomialDistribution.PeizerPrattMethod2Inversion(d2 + Math.sqrt(variance), this.oddSteps);
        double up = ermqdt * pdash / pu;
        double down = (ermqdt - pu * up) / (1.0 - pu);
        return this.x0 * Math.pow(down, i - index) * Math.pow(up, index);
    }

    @Override
    public double probability(int i, int ref, int branch) {
        double stepTime = (double)i * this.dt;
        double variance = this.treeProcess.variance(stepTime, this.x0, this.end);
        double d2 = (Math.log(this.x0 / this.strike) + this.driftStep(stepTime) * (double)this.oddSteps) / Math.sqrt(variance);
        double pu = BinomialDistribution.PeizerPrattMethod2Inversion(d2, this.oddSteps);
        double pd = 1.0 - pu;
        return branch == 1 ? pu : pd;
    }
}

