/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.QL;
import org.jquantlib.experimental.lattices.ExtendedBinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class ExtendedJoshi4
extends ExtendedBinomialTree {
    private final double end;
    private final int oddSteps;
    private final double strike;
    private final double up;
    private final double down;
    private final double pu;
    private final double pd;

    public ExtendedJoshi4(StochasticProcess1D process, double end, int steps, double strike) {
        super(process, end, steps % 2 != 0 ? steps : steps + 1);
        this.end = end;
        this.oddSteps = steps % 2 != 0 ? steps : steps + 1;
        this.strike = strike;
        QL.require(strike > 0.0, "strike must be positive");
        double variance = process.variance(0.0, this.x0, end);
        double ermqdt = Math.exp(this.driftStep(0.0) + 0.5 * variance / (double)this.oddSteps);
        double d2 = (Math.log(this.x0 / strike) + this.driftStep(0.0) * (double)this.oddSteps) / Math.sqrt(variance);
        this.pu = this.computeUpProb(((double)this.oddSteps - 1.0) / 2.0, d2);
        this.pd = 1.0 - this.pu;
        double pdash = this.computeUpProb(((double)this.oddSteps - 1.0) / 2.0, d2 + Math.sqrt(variance));
        this.up = ermqdt * pdash / this.pu;
        this.down = (ermqdt - this.pu * this.up) / (1.0 - this.pu);
        QL.require(this.pu <= 1.0, "negative probability");
        QL.require(this.pu >= 0.0, "negative probability");
    }

    @Override
    public double underlying(int i, int index) {
        double stepTime = (double)i * this.dt;
        double variance = this.treeProcess.variance(stepTime, this.x0, this.end);
        double ermqdt = Math.exp(this.driftStep(stepTime) + 0.5 * variance / (double)this.oddSteps);
        double d2 = (Math.log(this.x0 / this.strike) + this.driftStep(stepTime) * (double)this.oddSteps) / Math.sqrt(variance);
        double pu = this.computeUpProb(((double)this.oddSteps - 1.0) / 2.0, d2);
        double pdash = this.computeUpProb(((double)this.oddSteps - 1.0) / 2.0, d2 + Math.sqrt(variance));
        double up = ermqdt * pdash / pu;
        double down = (ermqdt - pu * up) / (1.0 - pu);
        return this.x0 * Math.pow(down, i - index) * Math.pow(up, index);
    }

    @Override
    public double probability(int i, int ref, int branch) {
        double stepTime = (double)i * this.dt;
        double variance = this.treeProcess.variance(stepTime, this.x0, this.end);
        double d2 = (Math.log(this.x0 / this.strike) + this.driftStep(stepTime) * (double)this.oddSteps) / Math.sqrt(variance);
        double pu = this.computeUpProb(((double)this.oddSteps - 1.0) / 2.0, d2);
        double pd = 1.0 - pu;
        return branch == 1 ? pu : pd;
    }

    private double computeUpProb(double k, double dj) {
        double alpha = dj / Math.sqrt(8.0);
        double alpha2 = alpha * alpha;
        double alpha3 = alpha * alpha2;
        double alpha5 = alpha3 * alpha2;
        double alpha7 = alpha5 * alpha2;
        double beta = -0.375 * alpha - alpha3;
        double gamma = 0.8333333333333334 * alpha5 + 1.0833333333333333 * alpha3 + 0.1953125 * alpha;
        double delta = -0.1025 * alpha - 0.9285 * alpha3 - 1.43 * alpha5 - 0.5 * alpha7;
        double p = 0.5;
        double rootk = Math.sqrt(k);
        p += alpha / rootk;
        p += beta / (k * rootk);
        p += gamma / (k * k * rootk);
        return p += delta / (k * k * k * rootk);
    }
}

