/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.QL;
import org.jquantlib.experimental.lattices.ExtendedEqualJumpsBinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class ExtendedCoxRossRubinstein
extends ExtendedEqualJumpsBinomialTree {
    public ExtendedCoxRossRubinstein(StochasticProcess1D process, double end, int steps, double strike) {
        super(process, end, steps);
        this.dx = process.stdDeviation(0.0, this.x0, this.dt);
        this.pu = 0.5 + 0.5 * this.driftStep(0.0) / this.dx;
        this.pd = 1.0 - this.pu;
        QL.require(this.pu <= 1.0, "negative probability");
        QL.require(this.pu >= 0.0, "negative probability");
    }

    @Override
    protected double dxStep(double stepTime) {
        return this.treeProcess.stdDeviation(stepTime, this.x0, this.dt);
    }

    @Override
    protected double probUp(double stepTime) {
        return 0.5 + 0.5 * this.driftStep(stepTime) / this.dxStep(stepTime);
    }
}

