/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.experimental.lattices;

import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.processes.StochasticProcess1D;

public abstract class ExtendedBinomialTree
extends Tree {
    protected static final Tree.Branches branches = Tree.Branches.BINOMIAL;
    protected static final String NEGATIVE_PROBABILITY = "negative probability";
    protected double x0;
    protected double driftPerStep;
    protected double dt;
    protected StochasticProcess1D treeProcess;

    public ExtendedBinomialTree(StochasticProcess1D process, double end, int steps) {
        super(steps + 1);
        this.treeProcess = process;
        this.x0 = process.x0();
        this.dt = end / (double)steps;
        this.driftPerStep = process.drift(0.0, this.x0) * this.dt;
    }

    @Override
    public int size(int i) {
        return i + 1;
    }

    @Override
    public int descendant(int ref, int index, int branch) {
        return index + branch;
    }

    protected double driftStep(double driftTime) {
        return this.treeProcess.drift(driftTime, this.x0) * this.dt;
    }
}

