/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Date;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Thirty360
extends DayCounter {
    public Thirty360() {
        this(Convention.BondBasis);
    }

    public Thirty360(Convention c) {
        switch (c) {
            case USA: 
            case BondBasis: {
                this.impl = new Impl_US();
                break;
            }
            case European: 
            case EurobondBasis: {
                this.impl = new Impl_EU();
                break;
            }
            case Italian: {
                this.impl = new Impl_IT();
                break;
            }
            default: {
                throw new LibraryException("unknown 30/360 convention");
            }
        }
    }

    private final class Impl_IT
    extends DayCounter.Impl {
        private Impl_IT() {
        }

        @Override
        protected final String name() {
            return "30/360 (Italian)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            return (double)this.dayCount(dateStart, dateEnd) / 360.0;
        }

        @Override
        protected long dayCount(Date d1, Date d2) {
            int dd1 = d1.dayOfMonth();
            int dd2 = d2.dayOfMonth();
            int mm1 = d1.month().value();
            int mm2 = d2.month().value();
            int yy1 = d1.year();
            int yy2 = d2.year();
            if (mm1 == 2 && dd1 > 27) {
                dd1 = 30;
            }
            if (mm2 == 2 && dd2 > 27) {
                dd2 = 30;
            }
            return 360 * (yy2 - yy1) + 30 * (mm2 - mm1 - 1) + Math.max(0, 30 - dd1) + Math.min(30, dd2);
        }
    }

    private final class Impl_EU
    extends DayCounter.Impl {
        private Impl_EU() {
        }

        @Override
        public final String name() {
            return "30E/360 (Eurobond Basis)";
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            return (double)this.dayCount(dateStart, dateEnd) / 360.0;
        }

        @Override
        protected long dayCount(Date d1, Date d2) {
            int dd1 = d1.dayOfMonth();
            int dd2 = d2.dayOfMonth();
            int mm1 = d1.month().value();
            int mm2 = d2.month().value();
            int yy1 = d1.year();
            int yy2 = d2.year();
            return 360 * (yy2 - yy1) + 30 * (mm2 - mm1 - 1) + Math.max(0, 30 - dd1) + Math.min(30, dd2);
        }
    }

    private final class Impl_US
    extends DayCounter.Impl {
        private Impl_US() {
        }

        @Override
        public final String name() {
            return "30/360 (Bond Basis)";
        }

        @Override
        protected long dayCount(Date d1, Date d2) {
            int dd1 = d1.dayOfMonth();
            int dd2 = d2.dayOfMonth();
            int mm1 = d1.month().value();
            int mm2 = d2.month().value();
            int yy1 = d1.year();
            int yy2 = d2.year();
            if (dd2 == 31 && dd1 < 30) {
                dd2 = 1;
                ++mm2;
            }
            return 360 * (yy2 - yy1) + 30 * (mm2 - mm1 - 1) + Math.max(0, 30 - dd1) + Math.min(30, dd2);
        }

        @Override
        public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
            return (double)this.dayCount(dateStart, dateEnd) / 360.0;
        }
    }

    public static enum Convention {
        USA,
        BondBasis,
        European,
        EurobondBasis,
        Italian;

    }
}

