/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.Coupon;
import org.jquantlib.cashflow.FloatingRateCouponPricer;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Observer;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class FloatingRateCoupon
extends Coupon
implements Observer {
    protected InterestRateIndex index_;
    protected DayCounter dayCounter_;
    protected int fixingDays_;
    protected double gearing_;
    protected double spread_;
    protected boolean isInArrears_;
    protected FloatingRateCouponPricer pricer_;

    public FloatingRateCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, InterestRateIndex index, double gearing, double spread, Date refPeriodStart, Date refPeriodEnd, DayCounter dayCounter, boolean isInArrears) {
        super(nominal, paymentDate, startDate, endDate, refPeriodStart, refPeriodEnd);
        this.index_ = index;
        this.dayCounter_ = dayCounter;
        this.fixingDays_ = fixingDays == 0 ? index.fixingDays() : fixingDays;
        this.gearing_ = gearing;
        this.spread_ = spread;
        this.isInArrears_ = isInArrears;
        QL.require(gearing != 0.0, "Null gearing not allowed");
        if (this.dayCounter_.empty()) {
            this.dayCounter_ = index.dayCounter();
        }
        Date evaluationDate = new Settings().evaluationDate();
        this.index_.addObserver(this);
        evaluationDate.addObserver(this);
    }

    public void setPricer(FloatingRateCouponPricer pricer) {
        if (this.pricer_ != null) {
            this.pricer_.deleteObserver(this);
        }
        this.pricer_ = pricer;
        if (this.pricer_ != null) {
            this.pricer_.addObserver(this);
        }
        this.update();
    }

    public FloatingRateCouponPricer pricer() {
        return this.pricer_;
    }

    @Override
    public double amount() {
        return this.rate() * this.accrualPeriod() * this.nominal();
    }

    @Override
    public double accruedAmount(Date d) {
        if (d.le(this.accrualStartDate_) || d.gt(this.paymentDate_)) {
            return 0.0;
        }
        return this.nominal() * this.rate() * this.dayCounter().yearFraction(this.accrualStartDate_, Date.min(d, this.accrualEndDate_), this.refPeriodStart_, this.refPeriodEnd_);
    }

    public double price(Handle<YieldTermStructure> yts) {
        return this.amount() * yts.currentLink().discount(this.date());
    }

    @Override
    public DayCounter dayCounter() {
        return this.dayCounter_;
    }

    public InterestRateIndex index() {
        return this.index_;
    }

    public int fixingDays() {
        return this.fixingDays_;
    }

    public Date fixingDate() {
        Date refDate = this.isInArrears_ ? this.accrualEndDate_ : this.accrualStartDate_;
        return this.index_.fixingCalendar().advance(refDate, new Period(-this.fixingDays_, TimeUnit.Days), BusinessDayConvention.Preceding);
    }

    public double gearing() {
        return this.gearing_;
    }

    public double spread() {
        return this.spread_;
    }

    public double indexFixing() {
        return this.index_.fixing(this.fixingDate());
    }

    @Override
    public double rate() {
        QL.require(this.pricer_ != null, "pricer not set");
        this.pricer_.initialize(this);
        return this.pricer_.swapletRate();
    }

    public double adjustedFixing() {
        return (this.rate() - this.spread()) / this.gearing();
    }

    public boolean isInArrears() {
        return this.isInArrears_;
    }

    public double convexityAdjustmentImpl(double f) {
        return this.gearing() == 0.0 ? 0.0 : this.adjustedFixing() - f;
    }

    public double convexityAdjustment() {
        return this.convexityAdjustmentImpl(this.indexFixing());
    }

    @Override
    public void update() {
        this.notifyObservers();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

