/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.FixedRateCoupon;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class FloatingLeg<InterestRateIndexType extends InterestRateIndex, FloatingCouponType extends FloatingRateCoupon, CappedFlooredCouponType>
extends Leg {
    private static final long serialVersionUID = 1L;
    private final Class<?> typeIRT;
    private final Class<?> typeFCT;
    private final Class<?> typeCFC;

    public FloatingLeg(Class<?> typeIRT, Class<?> typeFCT, Class<?> typeCFC, Array nominals, Schedule schedule, InterestRateIndexType index, DayCounter paymentDayCounter, BusinessDayConvention paymentAdj, Array fixingDays, Array gearings, Array spreads, Array caps, Array floors, boolean isInArrears, boolean isZero) {
        super(schedule.size() - 1);
        this.typeIRT = typeIRT;
        this.typeFCT = typeFCT;
        this.typeCFC = typeCFC;
        this.constructor(nominals, schedule, index, paymentDayCounter, paymentAdj, fixingDays, gearings, spreads, caps, floors, isInArrears, isZero);
    }

    private void constructor(Array nominals, Schedule schedule, InterestRateIndexType index, DayCounter paymentDayCounter, BusinessDayConvention paymentAdj, Array fixingDays, Array gearings, Array spreads, Array caps, Array floors, boolean isInArrears, boolean isZero) {
        int n = schedule.size() - 1;
        QL.require(nominals != null && nominals.size() <= n, "too many nominals (" + nominals.size() + "), only " + n + " required");
        QL.require(gearings != null && gearings.size() <= n, "too many gearings (" + gearings.size() + "), only " + n + " required");
        QL.require(spreads != null && spreads.size() <= n, "too many spreads (" + spreads.size() + "), only " + n + " required");
        QL.require(caps != null && caps.size() <= n, "too many caps (" + caps.size() + "), only " + n + " required");
        QL.require(floors != null && floors.size() <= n, "too many floors (" + floors.size() + "), only " + n + " required");
        QL.require(!isZero || !isInArrears, "in-arrears and zero features are not compatible");
        Calendar calendar = schedule.calendar();
        Date lastPaymentDate = calendar.adjust(schedule.date(n), paymentAdj);
        for (int i = 0; i < n; ++i) {
            Object cfctc;
            BusinessDayConvention bdc;
            Date paymentDate;
            Date end;
            Date start;
            Date refStart = start = schedule.date(i);
            Date refEnd = end = schedule.date(i + 1);
            Date date = paymentDate = isZero ? lastPaymentDate : calendar.adjust(end, paymentAdj);
            if (i == 0 && !schedule.isRegular(i + 1)) {
                bdc = schedule.businessDayConvention();
                refStart = calendar.adjust(end.sub(schedule.tenor()), bdc);
            }
            if (i == n - 1 && !schedule.isRegular(i + 1)) {
                bdc = schedule.businessDayConvention();
                refEnd = calendar.adjust(start.add(schedule.tenor()), bdc);
            }
            if (this.get(gearings, i, 1.0) == 0.0) {
                this.add(new FixedRateCoupon(this.get(nominals, i, 1.0), paymentDate, this.effectiveFixedRate(spreads, caps, floors, i), paymentDayCounter, start, end, refStart, refEnd));
                continue;
            }
            if (this.noOption(caps, floors, i)) {
                FloatingRateCoupon frc;
                try {
                    frc = (FloatingRateCoupon)this.typeFCT.getConstructor(Date.class, Double.TYPE, Date.class, Date.class, Integer.TYPE, IborIndex.class, Double.TYPE, Double.TYPE, Date.class, Date.class, DayCounter.class, Boolean.TYPE).newInstance(paymentDate, this.get(nominals, i, 1.0), start, end, (int)this.get(fixingDays, i, ((InterestRateIndex)index).fixingDays()), index, this.get(gearings, i, 1.0), this.get(spreads, i, 0.0), refStart, refEnd, paymentDayCounter, isInArrears);
                }
                catch (Exception e) {
                    throw new LibraryException("Couldn't construct new instance from generic type for floating coupon");
                }
                this.add(frc);
                continue;
            }
            try {
                cfctc = this.typeCFC.getConstructor(Date.class, Double.TYPE, Date.class, Date.class, Integer.TYPE, IborIndex.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Date.class, Date.class, DayCounter.class, Boolean.TYPE).newInstance(paymentDate, this.get(nominals, i, 1.0), start, end, (int)this.get(fixingDays, i, ((InterestRateIndex)index).fixingDays()), index, this.get(gearings, i, 1.0), this.get(spreads, i, 0.0), this.get(caps, i, Double.MAX_VALUE), this.get(floors, i, Double.MAX_VALUE), refStart, refEnd, paymentDayCounter, isInArrears);
            }
            catch (Exception e) {
                throw new LibraryException("Couldn't construct new instance from generic type:CappedFlooredCouponType");
            }
            this.add((CashFlow)cfctc);
        }
    }

    public double get(Array v, int i, double defaultValue) {
        if (v == null || v.empty()) {
            return defaultValue;
        }
        if (i < v.size()) {
            return v.get(i);
        }
        return v.get(v.size() - 1);
    }

    public double effectiveFixedRate(Array spreads, Array caps, Array floors, int i) {
        double cap;
        double result = this.get(spreads, i, 0.0);
        double floor = this.get(floors, i, Double.MAX_VALUE);
        if (floor != Double.MAX_VALUE) {
            result = Math.max(floor, result);
        }
        if ((cap = this.get(caps, i, Double.MAX_VALUE)) != Double.MAX_VALUE) {
            result = Math.min(cap, result);
        }
        return result;
    }

    public boolean noOption(Array caps, Array floors, int i) {
        return this.get(caps, i, Double.MAX_VALUE) == Double.MAX_VALUE && this.get(floors, i, Double.MAX_VALUE) == Double.MAX_VALUE;
    }
}

