/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.cashflow.Coupon;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class FixedRateCoupon
extends Coupon {
    private final InterestRate rate;
    private final DayCounter dayCounter;

    public FixedRateCoupon(double nominal, Date paymentDate, double rate, DayCounter dayCounter, Date accrualStartDate, Date accrualEndDate) {
        this(nominal, paymentDate, rate, dayCounter, accrualStartDate, accrualEndDate, new Date(), new Date());
    }

    public FixedRateCoupon(double nominal, Date paymentDate, double rate, DayCounter dayCounter, Date accrualStartDate, Date accrualEndDate, Date refPeriodStart, Date refPeriodEnd) {
        super(nominal, paymentDate, accrualStartDate, accrualEndDate, refPeriodStart, refPeriodEnd);
        this.rate = new InterestRate(rate, dayCounter, Compounding.Simple);
        this.dayCounter = dayCounter;
    }

    public FixedRateCoupon(double nominal, Date paymentDate, InterestRate interestRate, DayCounter dayCounter, Date accrualStartDate, Date accrualEndDate) {
        this(nominal, paymentDate, interestRate, dayCounter, accrualStartDate, accrualEndDate, new Date(), new Date());
    }

    public FixedRateCoupon(double nominal, Date paymentDate, InterestRate interestRate, DayCounter dayCounter, Date accrualStartDate, Date accrualEndDate, Date refPeriodStart, Date refPeriodEnd) {
        super(nominal, paymentDate, accrualStartDate, accrualEndDate, refPeriodStart, refPeriodEnd);
        this.rate = interestRate;
        this.dayCounter = dayCounter;
    }

    public InterestRate interestRate() {
        return this.rate;
    }

    @Override
    public DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public double rate() {
        return this.rate.rate();
    }

    @Override
    public double accruedAmount(Date d) {
        if (d.le(this.accrualStartDate_) || d.gt(this.paymentDate_)) {
            return 0.0;
        }
        Date minD = d.le(this.accrualEndDate_) ? d : this.accrualEndDate_;
        return this.nominal() * (this.rate.compoundFactor(this.accrualStartDate_, minD, this.refPeriodStart_, this.refPeriodEnd_) - 1.0);
    }

    @Override
    public double amount() {
        return this.nominal() * (this.rate.compoundFactor(this.accrualStartDate_, this.accrualEndDate_, this.refPeriodStart_, this.refPeriodEnd_) - 1.0);
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

