/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.Coupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Ops;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class CashFlows {
    private final String not_enough_information_available = "not enough information available";
    private final String no_cashflows = "no cashflows";
    private final String unsupported_compounding_type = "unsupported compounding type";
    private final String compounded_rate_required = "compounded rate required";
    private final String unsupported_frequency = "unsupported frequency";
    private final String unknown_duration_type = "unsupported duration type";
    private final String infeasible_cashflow = "the given cash flows cannot result in the given market price due to their sign";
    private static double basisPoint_ = 1.0E-4;
    private static volatile CashFlows instance = null;

    private CashFlows() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CashFlows getInstance() {
        if (instance != null) return instance;
        Class<CashFlows> clazz = CashFlows.class;
        synchronized (CashFlows.class) {
            if (instance != null) return instance;
            instance = new CashFlows();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Date startDate(Leg cashflows) {
        Date d = Date.maxDate();
        for (int i = 0; i < cashflows.size(); ++i) {
            Coupon c = (Coupon)cashflows.get(i);
            if (c == null) continue;
            d = Date.min(c.accrualStartDate(), d);
        }
        QL.ensure(d.lt(Date.maxDate()), "not enough information available");
        return d;
    }

    public Date maturityDate(Leg cashflows) {
        Date d = Date.minDate();
        for (int i = 0; i < cashflows.size(); ++i) {
            d = Date.max(d, ((CashFlow)cashflows.get(i)).date());
        }
        QL.ensure(d.gt(Date.minDate()), "no cashflows");
        return d;
    }

    public double npv(Leg cashflows, Handle<YieldTermStructure> discountCurve, Date settlementDate, Date npvDate) {
        return this.npv(cashflows, discountCurve, settlementDate, npvDate, 0);
    }

    public double npv(Leg cashflows, Handle<YieldTermStructure> discountCurve, Date settlementDate, Date npvDate, int exDividendDays) {
        Date date = settlementDate;
        if (date.isNull()) {
            date = discountCurve.currentLink().referenceDate();
        }
        double totalNPV = 0.0;
        for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(date.add(exDividendDays))) continue;
            totalNPV += ((CashFlow)cashflows.get(i)).amount() * discountCurve.currentLink().discount(((CashFlow)cashflows.get(i)).date());
        }
        if (npvDate.isNull()) {
            return totalNPV;
        }
        return totalNPV / discountCurve.currentLink().discount(npvDate);
    }

    public double npv(Leg leg, Handle<YieldTermStructure> discountCurve) {
        return this.npv(leg, discountCurve, new Date(), new Date(), 0);
    }

    public double npv(Leg cashflows, InterestRate irr, Date settlementDate) {
        Date date = settlementDate;
        if (date.isNull()) {
            date = new Settings().evaluationDate();
        }
        FlatForward flatRate = new FlatForward(date, irr.rate(), irr.dayCounter(), irr.compounding(), irr.frequency());
        return this.npv(cashflows, new Handle<YieldTermStructure>(flatRate), date, date, 0);
    }

    public double npv(Leg leg, InterestRate interestRate) {
        return this.npv(leg, interestRate, new Date());
    }

    public double bps(Leg cashflows, Handle<YieldTermStructure> discountCurve) {
        return this.bps(cashflows, discountCurve, new Settings().evaluationDate());
    }

    public double bps(Leg cashflows, Handle<YieldTermStructure> discountCurve, Date settlementDate) {
        return this.bps(cashflows, discountCurve, settlementDate, settlementDate);
    }

    public double bps(Leg cashflows, Handle<YieldTermStructure> discountCurve, Date settlementDate, Date npvDate) {
        return this.bps(cashflows, discountCurve, settlementDate, npvDate, 0);
    }

    public double bps(Leg cashflows, Handle<YieldTermStructure> discountCurve, Date settlementDate, Date npvDate, int exDividendDays) {
        Date date = settlementDate;
        if (date.isNull()) {
            date = discountCurve.currentLink().referenceDate();
        }
        BPSCalculator calc = new BPSCalculator(discountCurve, npvDate);
        for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(date.add(exDividendDays))) continue;
            ((CashFlow)cashflows.get(i)).accept(calc);
        }
        return basisPoint_ * calc.result();
    }

    public double bps(Leg cashflows, InterestRate irr, Date settlementDate) {
        if (settlementDate.isNull()) {
            settlementDate = new Settings().evaluationDate();
        }
        FlatForward flatRate = new FlatForward(settlementDate, irr.rate(), irr.dayCounter(), irr.compounding(), irr.frequency());
        return this.bps(cashflows, new Handle<YieldTermStructure>(flatRate), settlementDate, settlementDate);
    }

    public double atmRate(Leg leg, Handle<YieldTermStructure> discountCurve, Date settlementDate, Date npvDate, int exDividendDays, double npv) {
        double bps = this.bps(leg, discountCurve, settlementDate, npvDate, exDividendDays);
        if (npv == 0.0) {
            npv = this.npv(leg, discountCurve, settlementDate, npvDate, exDividendDays);
        }
        return basisPoint_ * npv / bps;
    }

    public double atmRate(Leg leg, Handle<YieldTermStructure> discountCurve) {
        return this.atmRate(leg, discountCurve, new Date(), new Date(), 0, 0.0);
    }

    public double irr(Leg cashflows, double marketPrice, DayCounter dayCounter, Compounding compounding, Frequency frequency, Date settlementDate, double tolerance, int maxIterations, double guess) {
        Date date = settlementDate;
        if (date.isNull()) {
            date = new Settings().evaluationDate();
        }
        int lastSign = this.sign(-marketPrice);
        int signChanges = 0;
        for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(date)) continue;
            int thisSign = this.sign(((CashFlow)cashflows.get(i)).amount());
            if (lastSign * thisSign < 0) {
                ++signChanges;
            }
            if (thisSign == 0) continue;
            lastSign = thisSign;
        }
        QL.ensure(signChanges > 0, "the given cash flows cannot result in the given market price due to their sign");
        Brent solver = new Brent();
        solver.setMaxEvaluations(maxIterations);
        return solver.solve(new IRRFinder(cashflows, marketPrice, dayCounter, compounding, frequency, date), tolerance, guess, guess / 10.0);
    }

    public double irr(Leg leg, double marketPrice, DayCounter dayCounter, Compounding compounding) {
        return this.irr(leg, marketPrice, dayCounter, compounding, Frequency.NoFrequency, new Date(), 1.0E-10, 10000, 0.05);
    }

    public double duration(Leg leg, InterestRate y, Duration duration, Date settlementDate) {
        Date date = settlementDate;
        if (date.isNull()) {
            date = new Settings().evaluationDate();
        }
        switch (duration) {
            case Simple: {
                return this.simpleDuration(leg, y, date);
            }
            case Modified: {
                return this.modifiedDuration(leg, y, date);
            }
            case Macaulay: {
                return this.macaulayDuration(leg, y, date);
            }
        }
        throw new LibraryException("unsupported duration type");
    }

    public double duration(Leg leg, InterestRate y) {
        return this.duration(leg, y, Duration.Modified, new Date());
    }

    public double convexity(Leg cashFlows, InterestRate rate, Date settlementDate) {
        Date date = settlementDate;
        if (date.isNull()) {
            date = new Settings().evaluationDate();
        }
        DayCounter dayCounter = rate.dayCounter();
        double P = 0.0;
        double d2Pdy2 = 0.0;
        double y = rate.rate();
        int N = rate.frequency().toInteger();
        block5: for (int i = 0; i < cashFlows.size(); ++i) {
            if (((CashFlow)cashFlows.get(i)).hasOccurred(date)) continue;
            double t = dayCounter.yearFraction(date, ((CashFlow)cashFlows.get(i)).date());
            double c = ((CashFlow)cashFlows.get(i)).amount();
            double B = rate.discountFactor(t);
            P += c * B;
            switch (rate.compounding()) {
                case Simple: {
                    d2Pdy2 += c * 2.0 * B * B * B * t * t;
                    continue block5;
                }
                case Compounded: {
                    d2Pdy2 += c * B * t * ((double)N * t + 1.0) / ((double)N * (1.0 + y / (double)N) * (1.0 + y / (double)N));
                    continue block5;
                }
                case Continuous: {
                    d2Pdy2 += c * B * t * t;
                    continue block5;
                }
                default: {
                    throw new LibraryException("unsupported compounding type");
                }
            }
        }
        if (P == 0.0) {
            return 0.0;
        }
        return d2Pdy2 / P;
    }

    public double convexity(Leg leg, InterestRate y) {
        return this.convexity(leg, y, new Date());
    }

    private double simpleDuration(Leg cashflows, InterestRate rate, Date settlementDate) {
        double P = 0.0;
        double tP = 0.0;
        for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(settlementDate)) continue;
            double t = rate.dayCounter().yearFraction(settlementDate, ((CashFlow)cashflows.get(i)).date());
            double c = ((CashFlow)cashflows.get(i)).amount();
            double B = rate.discountFactor(t);
            P += c * B;
            tP += t * c * B;
        }
        if (P == 0.0) {
            return 0.0;
        }
        return tP / P;
    }

    private double modifiedDuration(Leg cashflows, InterestRate rate, Date settlementDate) {
        double P = 0.0;
        double dPdy = 0.0;
        double y = rate.rate();
        int N = rate.frequency().toInteger();
        block5: for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(settlementDate)) continue;
            double t = rate.dayCounter().yearFraction(settlementDate, ((CashFlow)cashflows.get(i)).date());
            double c = ((CashFlow)cashflows.get(i)).amount();
            double B = rate.discountFactor(t);
            P += c * B;
            switch (rate.compounding()) {
                case Simple: {
                    dPdy -= c * B * B * t;
                    continue block5;
                }
                case Compounded: {
                    dPdy -= c * B * t / (1.0 + y / (double)N);
                    continue block5;
                }
                case Continuous: {
                    dPdy -= c * B * t;
                    continue block5;
                }
                default: {
                    throw new LibraryException("unsupported compounding type");
                }
            }
        }
        if (P == 0.0) {
            return 0.0;
        }
        return -dPdy / P;
    }

    private double macaulayDuration(Leg cashflows, InterestRate rate, Date settlementDate) {
        double y = rate.rate();
        int N = rate.frequency().toInteger();
        QL.require(rate.compounding().equals((Object)Compounding.Compounded), "compounded rate required");
        QL.require(N >= 1, "unsupported frequency");
        return (1.0 + y / (double)N) * this.modifiedDuration(cashflows, rate, settlementDate);
    }

    private int sign(double x) {
        if (x == 0.0) {
            return 0;
        }
        if (x > 0.0) {
            return 1;
        }
        return -1;
    }

    public final int previousCashFlow(Leg leg) {
        return this.previousCashFlow(leg, new Date());
    }

    public final int previousCashFlow(Leg leg, Date refDate) {
        if (refDate.isNull()) {
            refDate = new Settings().evaluationDate();
        }
        if (!((CashFlow)leg.get(0)).hasOccurred(refDate)) {
            return leg.size();
        }
        int i = this.nextCashFlowIndex(leg, refDate);
        Date beforeLastPaymentDate = ((CashFlow)leg.get(i - 1)).date();
        return this.nextCashFlowIndex(leg, beforeLastPaymentDate);
    }

    public final double previousCouponRate(Leg cashFlows) {
        return this.previousCouponRate(cashFlows, new Date());
    }

    public final double previousCouponRate(Leg cashFlows, Date settlement) {
        int cf = this.previousCashFlow(cashFlows, settlement);
        return this.couponRate(cashFlows, cashFlows, cf);
    }

    public final double nextCouponRate(Leg leg) {
        return this.nextCouponRate(leg, new Date());
    }

    public final double nextCouponRate(Leg cashFlows, Date settlement) {
        int cf = this.nextCashFlowIndex(cashFlows, settlement);
        return this.couponRate(cashFlows, cashFlows, cf);
    }

    public final CashFlow nextCashFlow(Leg cashFlows, Date settlement) {
        if (settlement.isNull()) {
            settlement = new Settings().evaluationDate();
        }
        for (int i = 0; i < cashFlows.size(); ++i) {
            if (((CashFlow)cashFlows.get(i)).hasOccurred(settlement)) continue;
            return (CashFlow)cashFlows.get(i);
        }
        return null;
    }

    public final int nextCashFlowIndex(Leg cashFlows, Date settlement) {
        if (settlement.isNull()) {
            settlement = new Settings().evaluationDate();
        }
        for (int i = 0; i < cashFlows.size(); ++i) {
            if (((CashFlow)cashFlows.get(i)).hasOccurred(settlement)) continue;
            return i;
        }
        return cashFlows.size();
    }

    public final CashFlow nextCashFlow(Leg cashFlows) {
        return this.nextCashFlow(cashFlows, new Date());
    }

    public final double yieldValueBasisPoint(Leg leg, InterestRate y, Date settlementDate) {
        double shift = 0.01;
        double dirtyPrice = this.npv(leg, y, settlementDate);
        double modifiedDuration = this.duration(leg, y, Duration.Modified, settlementDate);
        return 1.0 / (-dirtyPrice * modifiedDuration) * 0.01;
    }

    public final double yieldValueBasisPoint(Leg leg, InterestRate y) {
        return this.yieldValueBasisPoint(leg, y, new Date());
    }

    public final double couponRate(Leg leg, Leg iteratorLeg, int iteratorIndex) {
        if (iteratorLeg.size() <= iteratorIndex) {
            return 0.0;
        }
        Date paymentDate = ((CashFlow)iteratorLeg.get(iteratorIndex)).date();
        boolean firstCouponFound = false;
        double nominal = Double.MAX_VALUE;
        double accrualPeriod = Double.MAX_VALUE;
        DayCounter dc = null;
        double result = 0.0;
        for (int i = iteratorIndex; i < leg.size(); ++i) {
            CashFlow cf = (CashFlow)iteratorLeg.get(i);
            if (!cf.date().eq(paymentDate) || !(cf instanceof Coupon)) continue;
            Coupon cp = (Coupon)cf;
            if (firstCouponFound) {
                QL.require(nominal == cp.nominal() && accrualPeriod == cp.accrualPeriod() && dc == cp.dayCounter(), "cannot aggregate two different coupons");
            } else {
                firstCouponFound = true;
                nominal = cp.nominal();
                accrualPeriod = cp.accrualPeriod();
                dc = cp.dayCounter();
            }
            result += cp.rate();
        }
        QL.ensure(firstCouponFound, "next cashflow (" + paymentDate + ") is not a coupon");
        return result;
    }

    private final double basisPointValue(Leg leg, InterestRate y, Date settlementDate) {
        double shift = 1.0E-4;
        double dirtyPrice = this.npv(leg, y, settlementDate);
        double modifiedDuration = this.duration(leg, y, Duration.Modified, settlementDate);
        double convexity = this.convexity(leg, y, settlementDate);
        double delta = -modifiedDuration * dirtyPrice;
        double gamma = convexity / 100.0 * dirtyPrice;
        return (delta *= 1.0E-4) + 0.5 * (gamma *= 1.0E-8);
    }

    private final double basisPointValue(Leg leg, InterestRate y) {
        return this.basisPointValue(leg, y, new Date());
    }

    private class BPSCalculator
    implements PolymorphicVisitor {
        private static final String UNKNOWN_VISITABLE = "unknow visitable object";
        private final Handle<YieldTermStructure> termStructure;
        private final Date npvDate;
        private double result;

        public BPSCalculator(Handle<YieldTermStructure> termStructure, Date npvDate) {
            this.termStructure = termStructure;
            this.npvDate = npvDate;
            this.result = 0.0;
        }

        public double result() {
            if (this.npvDate.isNull()) {
                return this.result;
            }
            return this.result / this.termStructure.currentLink().discount(this.npvDate);
        }

        public <CashFlow> Visitor<CashFlow> visitor(Class<? extends CashFlow> klass) {
            if (Coupon.class.isAssignableFrom(klass)) {
                return new CouponVisitor();
            }
            if (CashFlow.class.isAssignableFrom(klass)) {
                return new CashFlowVisitor();
            }
            throw new LibraryException(UNKNOWN_VISITABLE);
        }

        private class CouponVisitor
        implements Visitor<CashFlow> {
            private CouponVisitor() {
            }

            @Override
            public void visit(CashFlow o) {
                Coupon c = (Coupon)o;
                BPSCalculator.this.result = BPSCalculator.this.result + c.accrualPeriod() * c.nominal() * ((YieldTermStructure)BPSCalculator.this.termStructure.currentLink()).discount(c.date());
            }
        }

        private class CashFlowVisitor
        implements Visitor<CashFlow> {
            private CashFlowVisitor() {
            }

            @Override
            public void visit(CashFlow o) {
            }
        }
    }

    private class IRRFinder
    implements Ops.DoubleOp {
        private final Leg cashflows_;
        private final double marketPrice_;
        private final DayCounter dayCounter_;
        private final Compounding compounding_;
        private final Frequency frequency_;
        private final Date settlementDate_;

        public IRRFinder(Leg cashflows, double marketPrice, DayCounter dayCounter, Compounding compounding, Frequency frequency, Date settlementDate) {
            this.cashflows_ = cashflows;
            this.marketPrice_ = marketPrice;
            this.dayCounter_ = dayCounter;
            this.compounding_ = compounding;
            this.frequency_ = frequency;
            this.settlementDate_ = settlementDate;
        }

        @Override
        public double op(double guess) {
            InterestRate rate = new InterestRate(guess, this.dayCounter_, this.compounding_, this.frequency_);
            double NPV = CashFlows.this.npv(this.cashflows_, rate, this.settlementDate_);
            return this.marketPrice_ - NPV;
        }
    }

    public static enum Duration {
        Simple,
        Macaulay,
        Modified;

    }
}

