/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.CappedFlooredCoupon;
import org.jquantlib.cashflow.IborCoupon;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.time.Date;

public class CappedFlooredIborCoupon
extends CappedFlooredCoupon {
    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, 1.0);
    }

    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, 0.0);
    }

    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, double cap, double floor) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, cap, floor, new Date(), new Date());
    }

    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, double cap, double floor, Date refPeriodStart, Date refPeriodEnd) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, cap, floor, refPeriodStart, refPeriodEnd, new DayCounter());
    }

    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, double cap, double floor, Date refPeriodStart, Date refPeriodEnd, DayCounter dayCounter) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, cap, floor, refPeriodStart, refPeriodEnd, dayCounter, false);
    }

    public CappedFlooredIborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, double cap, double floor, Date refPeriodStart, Date refPeriodEnd, DayCounter dayCounter, boolean isInArrears) {
        super(new IborCoupon(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, refPeriodStart, refPeriodEnd, dayCounter, isInArrears), cap, floor);
        QL.validateExperimentalMode();
    }
}

