/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.Event;
import org.jquantlib.time.Date;

public class Callability
extends Event {
    private final Price price;
    private final Type type;
    private final Date date;

    public Callability(Price price, Type type, Date date) {
        this.price = price;
        this.type = type;
        this.date = date;
    }

    @Override
    public Date date() {
        return this.date;
    }

    public Price price() {
        return this.price;
    }

    public Type type() {
        return this.type;
    }

    public static class Price {
        private final double amount;
        private Type type;

        public Price() {
            this.amount = 0.0;
        }

        public Price(double amount, Type type) {
            this.amount = amount;
            this.type = type;
        }

        public double amount() {
            QL.require(!Double.isNaN(this.amount), "no amount given");
            return this.amount;
        }

        public Type type() {
            return this.type;
        }

        public static enum Type {
            Dirty,
            Clean;

        }
    }

    public static enum Type {
        Call,
        Put;

    }
}

