/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.cashflow.AverageBMACoupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.BMAIndex;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class AverageBMALeg {
    private final Schedule schedule;
    private final BMAIndex index;
    private Array notionals;
    private DayCounter paymentDayCounter;
    private BusinessDayConvention paymentAdjustment;
    private Array gearings;
    private Array spreads;

    public AverageBMALeg(Schedule schedule, BMAIndex index) {
        this.schedule = schedule;
        this.index = index;
        this.paymentAdjustment = BusinessDayConvention.Following;
        this.gearings = new Array(0);
        this.spreads = new Array(0);
    }

    public final AverageBMALeg withNotionals(double notional) {
        this.notionals = new Array(new double[]{notional});
        return this;
    }

    public final AverageBMALeg withNotionals(Array notionals) {
        this.notionals = notionals;
        return this;
    }

    public final AverageBMALeg withPaymentDayCounter(DayCounter dayCounter) {
        this.paymentDayCounter = dayCounter;
        return this;
    }

    public final AverageBMALeg withPaymentAdjustment(BusinessDayConvention convention) {
        this.paymentAdjustment = convention;
        return this;
    }

    public AverageBMALeg withGearings(double gearing) {
        this.gearings = new Array(new double[]{gearing});
        return this;
    }

    public AverageBMALeg withGearings(Array gearings) {
        this.gearings = gearings;
        return this;
    }

    public AverageBMALeg withSpreads(double spread) {
        this.spreads = new Array(new double[]{spread});
        return this;
    }

    public AverageBMALeg withSpreads(Array spreads) {
        this.spreads = spreads;
        return this;
    }

    public Leg Leg() {
        QL.require(!this.notionals.empty(), "no notional given");
        Leg cashflows = new Leg();
        Calendar calendar = this.schedule.calendar();
        int n = this.schedule.size() - 1;
        for (int i = 0; i < n; ++i) {
            Date refStart = this.schedule.date(i);
            Date start = this.schedule.date(i);
            Date refEnd = this.schedule.date(i + 1);
            Date end = this.schedule.date(i + 1);
            Date paymentDate = calendar.adjust(end, this.paymentAdjustment);
            if (i == 0 && !this.schedule.isRegular(i + 1)) {
                refStart = calendar.adjust(end.sub(this.schedule.tenor()), this.paymentAdjustment);
            }
            if (i == n - 1 && !this.schedule.isRegular(i + 1)) {
                refEnd = calendar.adjust(start.add(this.schedule.tenor()), this.paymentAdjustment);
            }
            AverageBMACoupon coupon = new AverageBMACoupon(paymentDate, this.notionals.get(i) != 0.0 ? this.notionals.get(i) : this.notionals.last(), start, end, this.index, this.gearings.get(i) != 0.0 ? this.gearings.get(i) : 1.0, this.spreads.get(i) != 0.0 ? this.spreads.get(i) : 0.0, refStart, refEnd, this.paymentDayCounter);
            cashflows.add(coupon);
        }
        return cashflows;
    }
}

