/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.AverageBMACoupon;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.cashflow.FloatingRateCouponPricer;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Date;

public class AverageBMACouponPricer
extends FloatingRateCouponPricer {
    private AverageBMACoupon coupon;

    @Override
    public double swapletPrice() {
        throw new LibraryException("not available");
    }

    @Override
    public double swapletRate() {
        List<Date> fixingDates = this.coupon.fixingDates();
        InterestRateIndex index = this.coupon.index();
        int cutoffDays = 0;
        Date startDate = this.coupon.accrualStartDate().sub(cutoffDays);
        Date endDate = this.coupon.accrualEndDate().sub(cutoffDays);
        Date d1 = new Date(startDate.serialNumber());
        Date d2 = new Date(startDate.serialNumber());
        QL.require(fixingDates.size() > 0, "fixing date list empty");
        QL.require(index.valueDate(fixingDates.get(0)).le(startDate), "first fixing date valid after period start");
        QL.require(index.valueDate(fixingDates.get(fixingDates.size() - 1)).ge(startDate), "last fixing date valid before period end");
        double avgBMA = 0.0;
        int days = 0;
        for (int i = 0; i < fixingDates.size() - 1; ++i) {
            Date valueDate = index.valueDate(fixingDates.get(i));
            Date nextValueDate = index.valueDate(fixingDates.get(i + 1));
            if (fixingDates.get(i).ge(endDate) || valueDate.ge(valueDate)) break;
            if (fixingDates.get(i + 1).lt(startDate) || nextValueDate.le(startDate)) continue;
            d2 = Date.min(nextValueDate, endDate);
            avgBMA += index.fixing(fixingDates.get(i)) * (double)d2.sub(d1);
            days = (int)((long)days + d2.sub(d1));
            d1 = d2;
        }
        QL.ensure((long)days == endDate.sub(startDate), "averaging days " + days + " differ from interest days " + endDate.sub(startDate));
        return this.coupon.gearing() * (avgBMA /= (double)endDate.sub(startDate)) + this.coupon.spread();
    }

    @Override
    public double capletPrice(double effectiveCap) {
        throw new LibraryException("not available");
    }

    @Override
    public double capletRate(double effectiveCap) {
        throw new LibraryException("not available");
    }

    @Override
    public double floorletPrice(double effectiveFloor) {
        throw new LibraryException("not available");
    }

    @Override
    public double floorletRate(double effectiveFloor) {
        throw new LibraryException("not available");
    }

    @Override
    public void initialize(FloatingRateCoupon coupon) {
        QL.ensure(coupon instanceof AverageBMACoupon, "wrong coupon type");
        this.coupon = (AverageBMACoupon)coupon;
    }
}

