/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jquantlib.JQuantLib;
import org.jquantlib.lang.exceptions.LibraryException;

public class QL {
    public static void require(boolean condition, String format, Object ... objects) throws RuntimeException {
        if (!condition) {
            throw new LibraryException(String.format(format, objects));
        }
    }

    public static void require(boolean condition, String message) throws RuntimeException {
        if (!condition) {
            throw new LibraryException(message);
        }
    }

    public static void require(boolean condition, Class<? extends RuntimeException> klass, String message) throws RuntimeException {
        if (!condition) {
            try {
                Constructor<? extends RuntimeException> c = klass.getConstructor(String.class);
                throw c.newInstance(message);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void ensure(boolean condition, String format, Object ... objects) throws RuntimeException {
        if (!condition) {
            throw new LibraryException(String.format(format, objects));
        }
    }

    public static void ensure(boolean condition, String message) throws RuntimeException {
        if (!condition) {
            throw new LibraryException(message);
        }
    }

    public static void error(String message) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.error(message);
        } else {
            System.err.printf("ERROR: %s\n", message);
        }
    }

    public static void error(String message, Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.error(message, t);
        } else {
            System.err.printf("ERROR: %s : %s\n", message, t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void error(Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.error(t.getMessage(), t);
        } else {
            System.err.printf("ERROR: %s\n", t.getMessage());
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void warn(String message) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.warn(message);
        } else {
            System.err.printf("WARN: %s\n", message);
        }
    }

    public static void warn(String message, Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.warn(message, t);
        } else {
            System.err.printf("WARN: %s : %s\n", message, t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void warn(Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.warn(t.getMessage(), t);
        } else {
            System.err.printf("WARN: %s\n", t.getMessage());
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void info(String message) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.info(message);
        } else {
            System.err.printf("INFO: %s\n", message);
        }
    }

    public static void info(String message, Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.info(message, t);
        } else {
            System.err.printf("INFO: %s : %s\n", message, t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void info(Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.info(t.getMessage(), t);
        } else {
            System.err.printf("INFO: %s\n", t.getMessage());
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void debug(String message) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.debug(message);
        } else {
            System.err.printf("DEBUG: %s\n", message);
        }
    }

    public static void debug(String message, Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.debug(message, t);
        } else {
            System.err.printf("DEBUG: %s : %s\n", message, t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void debug(Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.debug(t.getMessage(), t);
        } else {
            System.err.printf("DEBUG: %s\n", t.getMessage());
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void trace(String message) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.trace(message);
        } else {
            System.err.printf("TRACE: %s\n", message);
        }
    }

    public static void trace(String message, Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.trace(message, t);
        } else {
            System.err.printf("TRACE: %s : %s\n", message, t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void trace(Throwable t) {
        if (JQuantLib.logger != null) {
            JQuantLib.logger.trace(t.getMessage(), t);
        } else {
            System.err.printf("TRACE: %s\n", t.getMessage());
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static void validateExperimentalMode() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }
}

