/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.gui.knowledgeflow.ShadowBorder;
import weka.gui.knowledgeflow.StepVisual;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.Note;

public class NoteVisual
extends StepVisual {
    private static final long serialVersionUID = -3291021235652124916L;
    protected JLabel m_label = new JLabel();
    protected int m_fontSizeAdjust = -1;

    @Override
    public void setStepManager(StepManagerImpl manager) {
        super.setStepManager(manager);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBorder(new ShadowBorder(2, Color.GRAY));
        this.m_label.setText(this.convertToHTML(((Note)this.getStepManager().getManagedStep()).getNoteText()));
        this.m_label.setOpaque(true);
        this.m_label.setBackground(Color.YELLOW);
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        holder.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        holder.setOpaque(true);
        holder.setBackground(Color.YELLOW);
        holder.add((Component)this.m_label, "Center");
        this.add((Component)holder, "Center");
    }

    public void setHighlighted(boolean highlighted) {
        if (highlighted) {
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.BLUE));
        } else {
            this.setBorder(new ShadowBorder(2, Color.GRAY));
        }
        this.revalidate();
    }

    @Override
    public void setDisplayConnectors(boolean dc) {
        this.m_displayConnectors = dc;
        this.m_connectorColor = Color.blue;
        this.setHighlighted(dc);
    }

    @Override
    public void setDisplayConnectors(boolean dc, Color c) {
        this.setDisplayConnectors(dc);
        this.m_connectorColor = c;
    }

    @Override
    public boolean getDisplayStepLabel() {
        return false;
    }

    @Override
    public void paintComponent(Graphics gx) {
        this.m_label.setText(this.convertToHTML(((Note)this.getStepManager().getManagedStep()).getNoteText()));
    }

    private String convertToHTML(String text) {
        String htmlString = text.replace("\n", "<br>");
        htmlString = "<html><font size=" + this.m_fontSizeAdjust + ">" + htmlString + "</font></html>";
        return htmlString;
    }

    public int getFontSizeAdjust() {
        return this.m_fontSizeAdjust;
    }

    public void setFontSizeAdjust(int adjust) {
        this.m_fontSizeAdjust = adjust;
    }

    public void decreaseFontSize() {
        --this.m_fontSizeAdjust;
    }

    public void increaseFontSize() {
        ++this.m_fontSizeAdjust;
    }
}

