/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.Token;

public abstract class TokenMarker {
    protected Token firstToken;
    protected Token lastToken;
    protected LineInfo[] lineInfo;
    protected int length;
    protected boolean nextLineRequested;

    public Token markTokens(Segment line, int lineIndex) {
        byte token;
        this.lastToken = null;
        LineInfo info = this.lineInfo[lineIndex];
        byte oldToken = info.token;
        info.token = token = this.markTokensImpl(lineIndex == 0 ? (byte)0 : this.lineInfo[lineIndex - 1].token, line, lineIndex);
        this.nextLineRequested = oldToken != token && this.lastToken != null;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    protected abstract byte markTokensImpl(byte var1, Segment var2, int var3);

    public void insertLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        this.length += lines;
        this.ensureCapacity(this.length);
        int len = index + lines;
        System.arraycopy(this.lineInfo, index, this.lineInfo, len, this.lineInfo.length - len);
        for (int i = index + lines - 1; i >= index; --i) {
            this.lineInfo[i] = new LineInfo();
        }
    }

    public void deleteLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        int len = index + lines;
        this.length -= lines;
        System.arraycopy(this.lineInfo, len, this.lineInfo, index, this.lineInfo.length - len);
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    protected TokenMarker() {
    }

    protected void ensureCapacity(int index) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[index + 1];
        } else if (this.lineInfo.length <= index) {
            LineInfo[] lineInfoN = new LineInfo[(index + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoN, 0, this.lineInfo.length);
            this.lineInfo = lineInfoN;
        }
    }

    protected void addToken(int length, byte id) {
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new Token(length, id);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = length;
            this.firstToken.id = id;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new Token(length, id);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = length;
            this.lastToken.id = id;
        }
    }

    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo() {
        }

        public LineInfo(byte token, Object obj) {
            this.token = token;
            this.obj = obj;
        }
    }
}

