/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.fitter;

import jas2.hist.FitFailed;
import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.FunctionValueUndefined;
import jas2.hist.IndeterminateMatrix;
import jas2.hist.InvalidFunctionParameter;
import jas2.hist.Matrix;

public class LeastSquaresFit
extends Fitter {
    private double m_chiSquared;
    private double[] m_sigmaA;

    @Override
    public void fit(Fittable1DFunction func, double[] x, double[] y, double[] sigmaY) throws FitFailed {
        int npts = x.length;
        if (npts != y.length || npts != sigmaY.length) {
            throw new IllegalArgumentException("Invalid arguments to fit");
        }
        double[] a = (double[])func.getParameterValues().clone();
        int nterms = a.length;
        this.m_sigmaA = new double[nterms];
        int nFree = npts - nterms;
        if (nFree <= 0) {
            throw new FitFailed("Insufficient degrees of Freedom");
        }
        double[] weight = new double[npts];
        for (int i = 0; i < npts; ++i) {
            weight[i] = sigmaY[i] == 0.0 ? 0.0 : 1.0 / sigmaY[i] / sigmaY[i];
        }
        double[] beta = new double[nterms];
        double[] b = new double[nterms];
        double[][] alpha = Matrix.create(nterms);
        double[][] array = Matrix.create(nterms);
        double lambda = 0.001;
        try {
            int iter = 0;
            while (true) {
                int j;
                int k;
                int j2;
                int j3;
                if (iter > 10000) {
                    throw new FitFailed("Fit exceeded maximum number of iterations");
                }
                double chisqr = this.calculateChiSquared(func, x, y, weight, a, nFree);
                for (j3 = 0; j3 < nterms; ++j3) {
                    beta[j3] = 0.0;
                    for (int k2 = 0; k2 <= j3; ++k2) {
                        alpha[j3][k2] = 0.0;
                    }
                }
                for (int i = 0; i < npts; ++i) {
                    double[] deriv = func.getDerivatives(x[i], a);
                    for (j2 = 0; j2 < nterms; ++j2) {
                        int n = j2;
                        beta[n] = beta[n] + weight[i] * (y[i] - func.valueAt(x[i], a)) * deriv[j2];
                        for (k = 0; k <= j2; ++k) {
                            double[] dArray = alpha[j2];
                            int n2 = k;
                            dArray[n2] = dArray[n2] + weight[i] * deriv[j2] * deriv[k];
                        }
                    }
                }
                for (j3 = 0; j3 < nterms; ++j3) {
                    for (int k3 = 0; k3 < j3; ++k3) {
                        alpha[k3][j3] = alpha[j3][k3];
                    }
                }
                double chisq1 = this.calculateChiSquared(func, x, y, weight, a, nFree);
                while (true) {
                    for (j2 = 0; j2 < nterms; ++j2) {
                        for (k = 0; k < nterms; ++k) {
                            array[j2][k] = alpha[j2][k] / Math.sqrt(alpha[j2][j2] * alpha[k][k]);
                        }
                        array[j2][j2] = 1.0 + lambda;
                    }
                    try {
                        double j4 = Matrix.invert(array);
                    }
                    catch (IndeterminateMatrix e) {
                        throw new FitFailed("Matrix became indeterminate during fit");
                    }
                    for (j = 0; j < nterms; ++j) {
                        b[j] = a[j];
                        for (k = 0; k < nterms; ++k) {
                            int n = j;
                            b[n] = b[n] + beta[k] * array[j][k] / Math.sqrt(alpha[j][j] * alpha[k][k]);
                        }
                    }
                    chisqr = this.calculateChiSquared(func, x, y, weight, b, nFree);
                    if (chisqr <= chisq1) break;
                    lambda *= 10.0;
                }
                for (j = 0; j < nterms; ++j) {
                    a[j] = b[j];
                    this.m_sigmaA[j] = Math.sqrt(array[j][j] / alpha[j][j]);
                }
                lambda /= 10.0;
                double delta = Math.abs(chisqr - this.m_chiSquared) / this.m_chiSquared;
                this.m_chiSquared = chisqr;
                if (delta < 0.001) break;
                this.setPercentComplete(10 * iter);
                ++iter;
            }
            try {
                func.setFit(this, a);
            }
            catch (InvalidFunctionParameter e) {
                throw new FitFailed("Unexpected exception: " + e);
            }
        }
        catch (FunctionValueUndefined e) {
            throw new FitFailed("Fit entered region where function value was undefined");
        }
    }

    private double calculateChiSquared(Fittable1DFunction func, double[] x, double[] y, double[] weight, double[] a, int nFree) throws FunctionValueUndefined {
        double result = 0.0;
        int npts = x.length;
        for (int i = 0; i < npts; ++i) {
            double delta = y[i] - func.valueAt(x[i], a);
            result += weight[i] * delta * delta;
        }
        return result / (double)nFree;
    }

    @Override
    public double getChiSquared() {
        return this.m_chiSquared;
    }

    @Override
    public double[] getParameterSigmas() {
        return this.m_sigmaA;
    }
}

