/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.xml.parserwrappers;

import jas2.util.xml.JASDOMParser;
import jas2.util.xml.parserwrappers.XMLErrorHandler;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXPDOMParser
extends JASDOMParser {
    @Override
    public Document parse(Reader in, String fileName) throws JASDOMParser.JASXMLException {
        return this.parse(in, fileName, null);
    }

    @Override
    public Document parse(Reader in, String fileName, EntityResolver resolver) throws JASDOMParser.JASXMLException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            XMLErrorHandler errorHandler = new XMLErrorHandler(fileName);
            parser.setErrorHandler(errorHandler);
            if (resolver != null) {
                parser.setEntityResolver(resolver);
            }
            InputSource is = new InputSource(in);
            is.setSystemId("file:/");
            Document doc = parser.parse(is);
            if (errorHandler.getLevel() > 1) {
                throw new SAXException("Error during XML file parsing");
            }
            return doc;
        }
        catch (SAXException x) {
            throw new JASDOMParser.JASXMLException("Syntax error parsing XML file", x);
        }
        catch (IOException x) {
            throw new JASDOMParser.JASXMLException("IO error parsing XML file", x);
        }
        catch (ParserConfigurationException x) {
            throw new JASDOMParser.JASXMLException("Can not create XML parser", x);
        }
    }
}

