/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.tree;

import jas2.util.tree.OrderedNode;
import jas2.util.tree.SimpleNode;
import jas2.util.tree.SimpleNodeListener;
import jas2.util.tree.TreeItem;
import java.io.File;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SimpleTreeModel
implements TreeModel {
    private EventListenerList listenerList = new EventListenerList();
    private SimpleNode m_root;
    private SimpleNodeListener m_nodeListener;

    public SimpleTreeModel(SimpleNode root) {
        this.m_root = root;
    }

    @Override
    public Object getRoot() {
        return this.m_root;
    }

    @Override
    public int getChildCount(Object parent) {
        SimpleNode p = (SimpleNode)parent;
        return p.getChildCount();
    }

    @Override
    public Object getChild(Object parent, int index) {
        SimpleNode p = (SimpleNode)parent;
        return p.getChild(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SimpleNode p = (SimpleNode)parent;
        return p.getIndexOfChild((SimpleNode)child);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
        if (this.m_nodeListener == null) {
            this.m_nodeListener = new SimpleListener();
            this.m_root.addNodeListener(this.m_nodeListener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
        if (this.listenerList.getListenerCount() == 0) {
            this.m_root.removeNodeListener(this.m_nodeListener);
            this.m_nodeListener = null;
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public static void main(String[] argv) {
        File dir = new File(System.getProperties().getProperty("user.home"));
        OrderedNode root = new OrderedNode();
        root.setOrder(new FolderComparator());
        OrderedNode here = new OrderedNode(root, dir.getName(), null, 4, dir);
        SimpleTreeModel.listFiles(here, dir);
        JFrame frame = new JFrame();
        frame.setContentPane(new JScrollPane(new JTree(new SimpleTreeModel(root))));
        frame.setSize(400, 400);
        frame.show();
    }

    private static void listFiles(SimpleNode root, File dir) {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            OrderedNode x = new OrderedNode(root, files[i], null, f.isDirectory() ? 4 : 0, dir);
            if (!f.isDirectory()) continue;
            SimpleTreeModel.listFiles(x, f);
        }
    }

    private static class FolderComparator
    implements Comparator {
        private FolderComparator() {
        }

        public int compare(Object p1, Object p2) {
            boolean f2;
            SimpleNode n1 = (SimpleNode)p1;
            SimpleNode n2 = (SimpleNode)p2;
            boolean f1 = (n1.getFlags() & 4) != 0;
            boolean bl = f2 = (n2.getFlags() & 4) != 0;
            if (f1 && !f2) {
                return -1;
            }
            if (!f1 && f2) {
                return 1;
            }
            return n1.getName().compareTo(n2.getName());
        }
    }

    private class SimpleListener
    implements SimpleNodeListener {
        private SimpleListener() {
        }

        @Override
        public void treeChanged(TreeItem item) {
            if ((item.flags & 8) != 0) {
                this.structureChanged(item);
            } else {
                this.nodesChanged(item);
            }
        }

        private void nodesChanged(TreeItem item) {
            SimpleNode parent;
            Object[] path = new SimpleNode[item.path.length];
            SimpleNode child = parent = SimpleTreeModel.this.m_root;
            int i = 0;
            while (true) {
                path[i] = parent;
                child = parent.findChild(item.path[i++]);
                if (i == path.length) break;
                parent = child;
            }
            Object[] children = new Object[]{child};
            int[] index = new int[]{parent.getIndexOfChild(child)};
            TreeModelEvent e = new TreeModelEvent((Object)this, new TreePath(path), index, children);
            if ((item.flags & 2) != 0) {
                SimpleTreeModel.this.fireTreeNodesRemoved(e);
            } else {
                SimpleTreeModel.this.fireTreeNodesInserted(e);
            }
        }

        public void structureChanged(TreeItem item) {
            Object[] path = new SimpleNode[item.path.length + 1];
            SimpleNode node = SimpleTreeModel.this.m_root;
            int i = 0;
            while (true) {
                path[i] = node;
                if (i >= item.path.length) break;
                node = node.findChild(item.path[i]);
                ++i;
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, new TreePath(path));
            SimpleTreeModel.this.fireTreeStructureChanged(e);
        }
    }
}

