/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.rmi;

import jas2.util.rmi.Preemptable;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RemoteEventReceiver;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class RMIEventQueue
extends Thread {
    private RemoteEventReceiver receiver;
    private Vector m_obs = new Vector();

    public RMIEventQueue(RemoteEventReceiver receiver) {
        this.receiver = receiver;
        this.start();
    }

    public void dispose() {
        Enumeration e = this.m_obs.elements();
        while (e.hasMoreElements()) {
            RMIObserver obs = (RMIObserver)e.nextElement();
            obs.stop();
        }
        this.interrupt();
    }

    public Observer setEventSource(RMIDestination destination) {
        RMIObserver obs = new RMIObserver(destination);
        this.m_obs.addElement(obs);
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                int i;
                RMIObserver a;
                Enumeration e;
                boolean messageWaiting = false;
                RMIEventQueue rMIEventQueue = this;
                synchronized (rMIEventQueue) {
                    e = this.m_obs.elements();
                    while (e.hasMoreElements() && !(messageWaiting = (a = (RMIObserver)e.nextElement()).hasMessages())) {
                    }
                    if (!messageWaiting) {
                        this.wait();
                    }
                }
                int n = 0;
                e = this.m_obs.elements();
                while (e.hasMoreElements()) {
                    a = (RMIObserver)e.nextElement();
                    i = a.getNUpdates();
                    if (i <= 0) continue;
                    n += i + 1;
                }
                if (n == 0) continue;
                Serializable[] s = new Serializable[n];
                i = 0;
                e = this.m_obs.elements();
                while (e.hasMoreElements()) {
                    RMIObserver a2 = (RMIObserver)e.nextElement();
                    Vector v = a2.getUpdates();
                    if (v.isEmpty()) continue;
                    s[i++] = a2.getDestination();
                    Enumeration e2 = v.elements();
                    while (e2.hasMoreElements()) {
                        s[i++] = (Serializable)e2.nextElement();
                    }
                }
                this.receiver.remoteUpdate(s);
            }
        }
        catch (InterruptedException e) {
            System.out.println("RMIEventQueue Thread terminating");
            this.receiver = null;
            this.receiver = null;
            this.m_obs = null;
        }
        catch (RemoteException e) {
            try {
                System.out.println("Error dispatching events " + e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.receiver = null;
                this.m_obs = null;
            }
        }
    }

    private class RMIObserver
    implements Observer {
        private boolean stopped = false;
        private Vector m_active = new Vector();
        private Vector m_queue = new Vector();
        private Vector m_result = new Vector();
        private RMIDestination dest;

        RMIObserver(RMIDestination dest) {
            this.dest = dest;
        }

        RMIDestination getDestination() {
            return this.dest;
        }

        void stop() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Observable obs, Object arg) {
            if (this.stopped) {
                return;
            }
            if (arg instanceof Serializable) {
                boolean wasEmpty = this.m_active.isEmpty();
                this.m_active.addElement(arg);
                if (wasEmpty) {
                    RMIEventQueue rMIEventQueue = RMIEventQueue.this;
                    synchronized (rMIEventQueue) {
                        RMIEventQueue.this.notifyAll();
                    }
                }
            } else {
                throw new RuntimeException("Argument for RMIObserver not serializable");
            }
        }

        boolean hasMessages() {
            return !this.stopped && !this.m_active.isEmpty();
        }

        int getNUpdates() {
            this.m_result.removeAllElements();
            if (this.m_active.isEmpty()) {
                return 0;
            }
            Vector v = this.m_active;
            this.m_queue.removeAllElements();
            this.m_active = this.m_queue;
            this.m_queue = v;
            int size = v.size();
            block0: for (int i = 0; i < size; ++i) {
                Serializable arg = (Serializable)v.elementAt(i);
                if (arg instanceof Preemptable) {
                    Preemptable p = (Preemptable)((Object)arg);
                    for (int j = i + 1; j < size; ++j) {
                        if (p.preemptedBy(v.elementAt(j))) continue block0;
                    }
                }
                this.m_result.addElement(arg);
            }
            return this.m_result.size();
        }

        Vector getUpdates() {
            return this.m_result;
        }
    }
}

