/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.multifunctionpanel;

import jas2.plot.EditableLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MultiFunctionPanel
extends JPanel {
    private Component previousGlassPane;
    private MovableObjectGlassPane mogp;
    private Point dragOffset;
    private Component selectedComponent;
    private MOPFocusListener fl;
    private JPopupMenu pm;
    private int cursorState;
    private int arrowHeadDrawState;
    private int labelBorderDrawState;
    private Point dragStart;
    private EditableLabel tempLabel;
    private MFPArrow tempArrow;
    private boolean arrowHeadFillState;
    private float arrowHeadLength = 15.0f;
    private int numRepaints = 0;
    private static final int REPAINT_FUDGE_FACTOR = 10;
    private static final int FULL_REPAINT = 5;
    private static int numEvents = 0;

    public MultiFunctionPanel() {
        this(Color.blue);
    }

    public MultiFunctionPanel(Color color) {
        super(null);
        this.enableEvents(50L);
        this.mogp = new MovableObjectGlassPane(color);
        this.fl = new MOPFocusListener();
        this.cursorState = 0;
        this.arrowHeadDrawState = 0;
        this.arrowHeadFillState = false;
        this.labelBorderDrawState = 0;
    }

    public int getCursorState() {
        return this.cursorState;
    }

    public void setCursorState(int newState) {
        this.cursorState = newState;
        this.setCursor(Cursor.getPredefinedCursor(this.getCursorDisplayType()));
    }

    public int getArrowHeadDrawState() {
        return this.arrowHeadDrawState;
    }

    public void setArrowHeadDrawState(int newState) {
        this.arrowHeadDrawState = newState;
    }

    public float getArrowHeadLength() {
        return this.arrowHeadLength;
    }

    public void setArrowHeadLength(float newLength) {
        this.arrowHeadLength = newLength;
    }

    public boolean getArrowHeadFillState() {
        return this.arrowHeadFillState;
    }

    public void setArrowHeadFillState(boolean newState) {
        this.arrowHeadFillState = newState;
    }

    public int getLabelBorderDrawState() {
        return this.labelBorderDrawState;
    }

    public void setLabelBorderDrawState(int newState) {
        this.labelBorderDrawState = newState;
    }

    public void showArrowConfigDialog() {
    }

    public int getCursorDisplayType() {
        switch (this.getCursorState()) {
            default: {
                System.out.println("DEFAULT");
                return 0;
            }
            case 1: {
                System.out.println("ARROW_DRAW");
                return 1;
            }
            case 2: 
        }
        System.out.println("LABEL_DRAW");
        return 1;
    }

    @Override
    protected void processContainerEvent(ContainerEvent e) {
        if (e.getID() == 300) {
            e.getChild().addFocusListener(this.fl);
        } else {
            e.getChild().removeFocusListener(this.fl);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.pm.show(e.getComponent(), e.getX(), e.getY());
        } else {
            block0 : switch (e.getID()) {
                case 500: {
                    if (this.mogp.theMOB.isCursorOverTheBorder(e.getPoint())) break;
                    this.selectedComponent = null;
                    this.hideGlassPane();
                    this.requestFocus();
                    break;
                }
                case 501: {
                    if (this.getCursor().getType() != 1) break;
                    this.dragStart = e.getPoint();
                    switch (this.getCursorState()) {
                        case 1: {
                            this.tempArrow = new MFPArrow(this.dragStart);
                            this.tempArrow.setLocation(this.dragStart);
                            this.add(this.tempArrow);
                            this.tempArrow.setVisible(true);
                            break;
                        }
                        case 2: {
                            this.tempLabel = new EditableLabel("Click here to enter some text.", "");
                            switch (this.labelBorderDrawState) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    this.tempLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                                    break;
                                }
                                case 2: {
                                    this.tempLabel.setBorder(BorderFactory.createLineBorder(Color.black, 5));
                                    break;
                                }
                            }
                            this.tempLabel.setLocation(this.dragStart);
                            this.tempLabel.setVisible(true);
                            this.tempLabel.setRequestFocusEnabled(true);
                            this.add(this.tempLabel);
                        }
                    }
                    break;
                }
                case 502: {
                    if (this.getCursor().getType() != 1) break;
                    switch (this.getCursorState()) {
                        case 1: 
                        case 2: {
                            this.repaint();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && this.getCursor().getType() == 1) {
            switch (this.getCursorState()) {
                case 1: {
                    this.updateArrowSizeAndLocation(this.tempArrow, e.getPoint());
                    if (++this.numRepaints % 5 == 0) {
                        this.repaint();
                        break;
                    }
                    this.repaint(new Rectangle(this.dragStart.x - 10, this.dragStart.y - 10, e.getPoint().x - this.dragStart.x + 20, e.getPoint().y - this.dragStart.y + 20));
                    break;
                }
                case 2: {
                    Point end = e.getPoint();
                    if (end.x > this.dragStart.x && end.y > this.dragStart.y) {
                        this.tempLabel.setSize(end.x - this.dragStart.x, end.y - this.dragStart.y);
                    }
                    this.validate();
                    break;
                }
            }
        }
    }

    private void updateArrowSizeAndLocation(MFPArrow p_arrow, Point p_newFinish) {
        Point start = p_arrow.getStart();
        p_arrow.updateFinish(p_newFinish);
        if (start.x < p_newFinish.x) {
            if (start.y < p_newFinish.y) {
                p_arrow.setLocation(start.x, start.y);
            } else {
                p_arrow.setLocation(start.x, p_newFinish.y);
            }
        } else if (start.y < p_newFinish.y) {
            p_arrow.setLocation(p_newFinish.x, start.y);
        } else {
            p_arrow.setLocation(p_newFinish.x, p_newFinish.y);
        }
        int buf = p_arrow.getArrowHeadBuffer();
        p_arrow.setLocation(p_arrow.getLocation().x - buf, p_arrow.getLocation().y - buf);
        p_arrow.setSize(Math.abs(p_arrow.getStart().x - p_arrow.getFinish().x) + 2 * buf, Math.abs(p_arrow.getStart().y - p_arrow.getFinish().y) + 2 * buf);
        p_arrow.updateThetaAndArrowHeads();
        p_arrow.invalidate();
    }

    private void hideGlassPane() {
        if (this.previousGlassPane != null) {
            this.getRootPane().setGlassPane(this.previousGlassPane);
            this.getRootPane().getGlassPane().setVisible(false);
        }
    }

    private void showGlassPane() {
        this.previousGlassPane = this.getRootPane().getGlassPane();
        this.getRootPane().setGlassPane(this.mogp);
        this.mogp.setVisible(true);
    }

    class MovableObjectGlassPane
    extends JComponent {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point offsetFromTopLeftCorner;
        Rectangle initialSize = null;
        MovableObjectBorder theMOB;
        private int currentCursor;
        private int repaintExtra = 20;

        MovableObjectGlassPane() {
            this(Color.blue);
        }

        MovableObjectGlassPane(Color color) {
            this.enableEvents(50L);
            this.theMOB = new MovableObjectBorder(color, 7, 7, 5, Color.red, 8, 6);
        }

        @Override
        public void paint(Graphics g) {
            this.theMOB.paint(g);
        }

        public int getCursor(Point p) {
            if (this.theMOB != null) {
                return this.theMOB.getCursor(p);
            }
            Cursor theCursor = super.getCursor();
            if (theCursor == null) {
                return 0;
            }
            return theCursor.getType();
        }

        private Point findOffset(Point a, Point b) {
            return new Point(b.x - a.x, b.y - a.y);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.isPopupTrigger()) {
                System.out.println("popup from glass pane!");
            } else {
                block0 : switch (e.getID()) {
                    case 500: {
                        this.redispatchMouseEvent(e);
                        break;
                    }
                    case 504: {
                        this.redispatchMouseEvent(e);
                        break;
                    }
                    case 505: {
                        this.redispatchMouseEvent(e);
                        break;
                    }
                    case 501: {
                        if (MultiFunctionPanel.this.mogp.getCursor() == null) break;
                        switch (MultiFunctionPanel.this.mogp.getCursor().getType()) {
                            case 13: {
                                Point topLeftCorner = MultiFunctionPanel.this.selectedComponent.getLocation();
                                this.offsetFromTopLeftCorner = this.findOffset(topLeftCorner, e.getPoint());
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                this.initialSize = MultiFunctionPanel.this.selectedComponent.getBounds();
                                break block0;
                            }
                            case 1: {
                                MultiFunctionPanel.this.dragStart = e.getPoint();
                                break block0;
                            }
                        }
                        this.redispatchMouseEvent(e);
                        break;
                    }
                    case 502: {
                        this.repaint();
                        if (MultiFunctionPanel.this.mogp.getCursor() != null) {
                            if (MultiFunctionPanel.this.mogp.getCursor().getType() == 13) {
                                this.moveSelectedComponent(e.getPoint());
                                break;
                            }
                            this.redispatchMouseEvent(e);
                            break;
                        }
                        this.redispatchMouseEvent(e);
                        break;
                    }
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            switch (e.getID()) {
                case 503: {
                    this.redispatchMouseEvent(e);
                    int newCursor = this.theMOB.getCursor(e.getPoint());
                    if (newCursor == this.currentCursor) break;
                    MultiFunctionPanel.this.mogp.setCursor(Cursor.getPredefinedCursor(newCursor));
                    this.currentCursor = newCursor;
                    break;
                }
                case 506: {
                    Rectangle r = this.theMOB.getBorderRectangleOnTheGlassPane();
                    this.repaint(r.x - this.repaintExtra, r.y - this.repaintExtra, r.width + this.repaintExtra * 2, r.height + this.repaintExtra * 2);
                    if (MultiFunctionPanel.this.mogp.getCursor().getType() == 13) {
                        this.moveSelectedComponent(e.getPoint());
                        break;
                    }
                    switch (MultiFunctionPanel.this.mogp.getCursor().getType()) {
                        case 8: {
                            this.resizeVertical(e.getPoint(), true);
                            break;
                        }
                        case 11: {
                            this.resizeHorizontal(e.getPoint(), false);
                            break;
                        }
                        case 9: {
                            this.resizeVertical(e.getPoint(), false);
                            break;
                        }
                        case 10: {
                            this.resizeHorizontal(e.getPoint(), true);
                            break;
                        }
                        case 7: {
                            this.resizeVertical(e.getPoint(), true);
                            this.resizeHorizontal(e.getPoint(), false);
                            break;
                        }
                        case 6: {
                            this.resizeVertical(e.getPoint(), true);
                            this.resizeHorizontal(e.getPoint(), true);
                            break;
                        }
                        case 5: {
                            this.resizeVertical(e.getPoint(), false);
                            this.resizeHorizontal(e.getPoint(), false);
                            break;
                        }
                        case 4: {
                            this.resizeVertical(e.getPoint(), false);
                            this.resizeHorizontal(e.getPoint(), true);
                            break;
                        }
                        default: {
                            this.redispatchMouseEvent(e);
                            return;
                        }
                    }
                    this.validate();
                    break;
                }
            }
        }

        private boolean isPointInWindow(Point thePoint) {
            return thePoint.x <= MultiFunctionPanel.this.getSize().width && thePoint.x > 0 && thePoint.y <= MultiFunctionPanel.this.getSize().height && thePoint.y > 0;
        }

        private void moveSelectedComponent(Point currentPoint) {
            Point topLeftCorner = new Point(currentPoint.x - this.offsetFromTopLeftCorner.x, currentPoint.y - this.offsetFromTopLeftCorner.y);
            int buttonLeftEdge = topLeftCorner.x;
            int buttonRightEdge = topLeftCorner.x + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().width;
            int buttonTopEdge = topLeftCorner.y;
            int buttonBottomEdge = topLeftCorner.y + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().height;
            if (buttonLeftEdge < 0) {
                topLeftCorner.x = 0;
            } else if (buttonRightEdge >= MultiFunctionPanel.this.getSize().width) {
                topLeftCorner.x = MultiFunctionPanel.this.getSize().width - ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().width;
            }
            if (buttonTopEdge < 0) {
                topLeftCorner.y = 0;
            } else if (buttonBottomEdge >= MultiFunctionPanel.this.getSize().height) {
                topLeftCorner.y = MultiFunctionPanel.this.getSize().height - ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().height;
            }
            MultiFunctionPanel.this.selectedComponent.setLocation(topLeftCorner);
        }

        private Point mapToPointInWindow(Point currentPoint) {
            Point retval = new Point();
            retval.x = currentPoint.x > MultiFunctionPanel.this.getSize().width ? MultiFunctionPanel.this.getSize().width : (currentPoint.x < 0 ? 0 : currentPoint.x);
            retval.y = currentPoint.y > MultiFunctionPanel.this.getSize().height ? MultiFunctionPanel.this.getSize().height : (currentPoint.y < 0 ? 0 : currentPoint.y);
            return retval;
        }

        private void resizeSelectedComponentIfArrow() {
            if (MultiFunctionPanel.this.selectedComponent instanceof MFPArrow) {
                int buf = ((MFPArrow)MultiFunctionPanel.this.selectedComponent).getArrowHeadBuffer();
                int startx = 0;
                int starty = 0;
                int finishx = 0;
                int finishy = 0;
                switch (((MFPArrow)MultiFunctionPanel.this.selectedComponent).getQuadrant()) {
                    case 1: {
                        System.out.println("q1");
                        startx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + buf;
                        starty = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().height - 2 * buf;
                        finishx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().width - 2 * buf;
                        finishy = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + buf;
                        break;
                    }
                    case 2: {
                        System.out.println("q2");
                        startx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().width - 2 * buf;
                        starty = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().height - 2 * buf;
                        finishx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + buf;
                        finishy = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + buf;
                        break;
                    }
                    case 3: {
                        System.out.println("q3");
                        startx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().width - 2 * buf;
                        starty = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + buf;
                        finishx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + buf;
                        finishy = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().height - 2 * buf;
                        break;
                    }
                    case 4: {
                        System.out.println("q4");
                        startx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + buf;
                        starty = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + buf;
                        finishx = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().x + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().width - 2 * buf;
                        finishy = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().y + ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getBounds().height - 2 * buf;
                        break;
                    }
                }
                ((MFPArrow)MultiFunctionPanel.this.selectedComponent).updateStart(new Point(startx, starty));
                ((MFPArrow)MultiFunctionPanel.this.selectedComponent).updateFinish(new Point(finishx, finishy));
                ((MFPArrow)MultiFunctionPanel.this.selectedComponent).updateThetaAndArrowHeads();
            }
        }

        private void resizeVertical(Point currentPoint, boolean isNorthHandle) {
            Point currentWindowPoint = this.mapToPointInWindow(currentPoint);
            Point initialWindowPoint = SwingUtilities.convertPoint(MultiFunctionPanel.this, new Point(this.initialSize.x, this.initialSize.y), MultiFunctionPanel.this.mogp);
            Rectangle b = MultiFunctionPanel.this.selectedComponent.getBounds();
            int newHeight = isNorthHandle ? this.initialSize.height + initialWindowPoint.y - currentWindowPoint.y : currentWindowPoint.y - initialWindowPoint.y;
            if (newHeight >= ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().height) {
                if (isNorthHandle) {
                    b.y = SwingUtilities.convertPoint((Component)((MultiFunctionPanel)MultiFunctionPanel.this).mogp, (Point)currentWindowPoint, (Component)MultiFunctionPanel.this).y;
                }
                b.height = newHeight;
            } else {
                if (isNorthHandle) {
                    b.y = SwingUtilities.convertPoint((Component)((MultiFunctionPanel)MultiFunctionPanel.this).mogp, (Point)new Point((int)initialWindowPoint.x, (int)(initialWindowPoint.y + this.initialSize.height - ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().height)), (Component)MultiFunctionPanel.this).y;
                }
                b.height = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().height;
            }
            MultiFunctionPanel.this.selectedComponent.setBounds(b);
            this.resizeSelectedComponentIfArrow();
        }

        private void resizeHorizontal(Point currentPoint, boolean isWestHandle) {
            Point currentWindowPoint = this.mapToPointInWindow(currentPoint);
            Point initialWindowPoint = SwingUtilities.convertPoint(MultiFunctionPanel.this, new Point(this.initialSize.x, this.initialSize.y), MultiFunctionPanel.this.mogp);
            Rectangle b = MultiFunctionPanel.this.selectedComponent.getBounds();
            int newWidth = isWestHandle ? this.initialSize.width + initialWindowPoint.x - currentWindowPoint.x : currentWindowPoint.x - initialWindowPoint.x;
            if (newWidth >= ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().width) {
                if (isWestHandle) {
                    b.x = SwingUtilities.convertPoint((Component)((MultiFunctionPanel)MultiFunctionPanel.this).mogp, (Point)currentWindowPoint, (Component)MultiFunctionPanel.this).x;
                }
                b.width = newWidth;
            } else {
                if (isWestHandle) {
                    b.x = SwingUtilities.convertPoint((Component)((MultiFunctionPanel)MultiFunctionPanel.this).mogp, (Point)new Point((int)(initialWindowPoint.x + this.initialSize.width - ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().width), (int)initialWindowPoint.y), (Component)MultiFunctionPanel.this).x;
                }
                b.width = ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().width;
            }
            MultiFunctionPanel.this.selectedComponent.setBounds(b);
            this.resizeSelectedComponentIfArrow();
        }

        private void redispatchMouseEvent(MouseEvent e) {
            Point glassPanePoint = e.getPoint();
            Component component = null;
            JComponent container = MultiFunctionPanel.this;
            Point containerPoint = SwingUtilities.convertPoint(MultiFunctionPanel.this.mogp, glassPanePoint, MultiFunctionPanel.this);
            if (containerPoint.y < 0) {
                container = this.getRootPane().getJMenuBar();
                containerPoint = SwingUtilities.convertPoint(MultiFunctionPanel.this.mogp, glassPanePoint, this.getRootPane().getJMenuBar());
            }
            if (container != null && (containerPoint.y >= 0 || this.getRootPane().getJMenuBar() != null)) {
                component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
            }
            if (component == null) {
                return;
            }
            Point componentPoint = SwingUtilities.convertPoint(MultiFunctionPanel.this.mogp, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }

        class MovableObjectBorder {
            private Color lineColor;
            private int lineWidth;
            private int lineHeight;
            private int insetsFromRealBorder = 5;
            private Color handleColor;
            private int cornerHandleSideLength;
            private int sideHandleSideLength;
            private final int thickness = 6;
            private final int thick2 = 3;
            private Handle[] handles = new Handle[8];

            MovableObjectBorder(Color lineColor, int lineWidth, int lineHeight, int insetsFromRealBorder, Color handleColor, int cornerHandleSideLength, int sideHandleSideLength) {
                this.lineColor = lineColor;
                this.lineWidth = lineWidth;
                this.lineHeight = lineHeight;
                this.insetsFromRealBorder = insetsFromRealBorder;
                this.handleColor = handleColor;
                this.cornerHandleSideLength = cornerHandleSideLength;
                this.sideHandleSideLength = sideHandleSideLength;
                for (int i = 0; i < this.handles.length; ++i) {
                    this.handles[i] = new Handle(6);
                }
            }

            public int getCursor(Point p) {
                Rectangle r = this.getBorderRectangleOnTheGlassPane();
                Handle[] h = this.getHandles(r.x, r.y, r.width, r.height);
                for (int i = 0; i < h.length; ++i) {
                    if (!h[i].contains(p)) continue;
                    return h[i].getCursor();
                }
                if (this.isCursorOverTheBorder(p)) {
                    return 13;
                }
                return 0;
            }

            public void paint(Graphics g) {
                if (MultiFunctionPanel.this.selectedComponent == null) {
                    return;
                }
                Color oldColor = g.getColor();
                Rectangle r = this.getBorderRectangleOnTheGlassPane();
                Handle[] theHandles = this.getHandles(r.x, r.y, r.width, r.height);
                g.setColor(this.lineColor);
                g.drawRect(r.x, r.y, r.width, r.height);
                for (int i = 0; i < theHandles.length; ++i) {
                    g.fillRect(theHandles[i].x, theHandles[i].y, theHandles[i].width, theHandles[i].height);
                }
                g.setColor(oldColor);
            }

            private Handle[] getHandles(int xx, int yy, int ww, int hh) {
                this.handles[0].set(6, xx, yy);
                this.handles[1].set(7, xx + ww, yy);
                this.handles[2].set(5, xx + ww, yy + hh);
                this.handles[3].set(4, xx, yy + hh);
                this.handles[4].set(8, xx + ww / 2, yy);
                this.handles[5].set(9, xx + ww / 2, yy + hh);
                this.handles[6].set(10, xx, yy + hh / 2);
                this.handles[7].set(11, xx + ww, yy + hh / 2);
                return this.handles;
            }

            public Rectangle getMinimumBorderRectangle() {
                return this.getEquivalentBorderRectangle(new Rectangle(((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getLocation().x, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getLocation().y, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().width, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getMinimumSize().height));
            }

            public Rectangle getBorderRectangleOnTheGlassPane() {
                Point equivPt = SwingUtilities.convertPoint(MultiFunctionPanel.this, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getLocation().x, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getLocation().y, MultiFunctionPanel.this.mogp);
                return this.getEquivalentBorderRectangle(new Rectangle(equivPt.x, equivPt.y, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getSize().width, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getSize().height));
            }

            private Rectangle getBorderRectangle() {
                return this.getEquivalentBorderRectangle(new Rectangle(((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getLocation().x, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getLocation().y, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getSize().width, ((MultiFunctionPanel)MultiFunctionPanel.this).selectedComponent.getSize().height));
            }

            private Rectangle getEquivalentBorderRectangle(Rectangle r) {
                return new Rectangle(r.x - 4, r.y - 4, r.width + 6, r.height + 6);
            }

            public boolean isCursorOverTheBorder(Point p) {
                if (MultiFunctionPanel.this.selectedComponent == null) {
                    return false;
                }
                int extra = 3;
                Rectangle r = this.getBorderRectangleOnTheGlassPane();
                if (p.x >= r.x - extra && p.x <= r.x + r.width + extra && p.y >= r.y - extra && p.y <= r.y + r.height + extra) {
                    return p.x <= r.x + this.lineWidth || p.x >= r.x + r.width - this.lineWidth || p.y <= r.y + this.lineHeight || p.y >= r.y + r.height - this.lineHeight;
                }
                return false;
            }

            private final class Handle
            extends Rectangle {
                private int thick2;
                private int type;

                Handle(int size) {
                    this.setSize(size - 1, size - 1);
                    this.thick2 = size / 2;
                }

                void set(int type, int x, int y) {
                    this.setLocation(x - this.thick2, y - this.thick2);
                    this.type = type;
                }

                int getCursor() {
                    return this.type;
                }
            }
        }
    }

    class MOPFocusListener
    extends FocusAdapter {
        MOPFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MultiFunctionPanel.this.selectedComponent = e.getComponent();
            MultiFunctionPanel.this.showGlassPane();
        }

        @Override
        public void focusLost(FocusEvent e) {
            MultiFunctionPanel.this.hideGlassPane();
        }
    }

    public static interface LabelBorderDrawStates {
        public static final int NONE = 0;
        public static final int THIN = 1;
        public static final int THICK = 2;
    }

    public static interface ArrowheadDrawStates {
        public static final int NONE = 0;
        public static final int FINISH = 1;
        public static final int START = 2;
        public static final int BOTH = 3;
    }

    public static interface CursorStates {
        public static final int DEFAULT = 0;
        public static final int ARROW_DRAW = 1;
        public static final int LABEL_DRAW = 2;
    }

    class MFPArrow
    extends MFPComponent {
        private double m1_alpha;
        private double m1_theta;
        private Point m1_start;
        private Point m1_finish;
        private MFPArrowHead m1_startArrowHead;
        private MFPArrowHead m1_finishArrowHead;
        private int m1_lineAreaWidth;
        private int m1_arrowHeadBuffer;

        public MFPArrow(Point start) {
            this(start, 10.0);
        }

        public MFPArrow(Point start, double alpha) {
            this.m1_lineAreaWidth = 5;
            this.m1_arrowHeadBuffer = 0;
            this.m1_finish = this.m1_start = start;
            this.m1_alpha = alpha;
            switch (MultiFunctionPanel.this.getArrowHeadDrawState()) {
                case 0: {
                    break;
                }
                case 2: {
                    this.m1_startArrowHead = new MFPArrowHead(MultiFunctionPanel.this.getArrowHeadLength(), MultiFunctionPanel.this.getArrowHeadFillState(), false);
                    this.m1_arrowHeadBuffer = this.m1_startArrowHead.getArrowHeadBuffer();
                    break;
                }
                case 1: {
                    this.m1_finishArrowHead = new MFPArrowHead(MultiFunctionPanel.this.getArrowHeadLength(), MultiFunctionPanel.this.getArrowHeadFillState(), true);
                    this.m1_arrowHeadBuffer = this.m1_finishArrowHead.getArrowHeadBuffer();
                    break;
                }
                case 3: {
                    this.m1_startArrowHead = new MFPArrowHead(MultiFunctionPanel.this.getArrowHeadLength(), MultiFunctionPanel.this.getArrowHeadFillState(), false);
                    this.m1_finishArrowHead = new MFPArrowHead(MultiFunctionPanel.this.getArrowHeadLength(), MultiFunctionPanel.this.getArrowHeadFillState(), true);
                    this.m1_arrowHeadBuffer = this.m1_startArrowHead.getArrowHeadBuffer();
                    break;
                }
                default: {
                    System.out.println("ERROR: illegal arrowHeadState");
                }
            }
            this.enableEvents(56L);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public int getArrowHeadBuffer() {
            return this.m1_arrowHeadBuffer;
        }

        @Override
        public boolean contains(int x, int y) {
            return this.contains(new Point(x, y));
        }

        @Override
        public boolean contains(Point p) {
            return this.isPointInLineArea(p) || this.m1_startArrowHead != null && this.m1_startArrowHead.contains(p) || this.m1_finishArrowHead != null && this.m1_finishArrowHead.contains(p);
        }

        public void updateStart(Point start) {
            this.m1_start = start;
        }

        public void updateFinish(Point finish) {
            this.m1_finish = finish;
        }

        public void updateThetaAndArrowHeads() {
            this.calcTheta();
            if (this.m1_startArrowHead != null) {
                this.m1_startArrowHead.recalculateArea();
            }
            if (this.m1_finishArrowHead != null) {
                this.m1_finishArrowHead.recalculateArea();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            switch (this.getQuadrant()) {
                case 1: {
                    g.drawLine(this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer, this.getSize().width - this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer);
                    break;
                }
                case 2: {
                    g.drawLine(this.getSize().width - this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer);
                    break;
                }
                case 3: {
                    g.drawLine(this.getSize().width - this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer);
                    break;
                }
                case 4: {
                    g.drawLine(this.m1_arrowHeadBuffer, this.m1_arrowHeadBuffer, this.getSize().width - this.m1_arrowHeadBuffer, this.getSize().height - this.m1_arrowHeadBuffer);
                    break;
                }
            }
            if (this.m1_startArrowHead != null) {
                this.m1_startArrowHead.drawYourself(g);
            }
            if (this.m1_finishArrowHead != null) {
                this.m1_finishArrowHead.drawYourself(g);
            }
        }

        public int getQuadrant() {
            if (this.getXlen() >= 0) {
                if (this.getYlen() > 0) {
                    return 4;
                }
                return 1;
            }
            if (this.getYlen() > 0) {
                return 3;
            }
            return 2;
        }

        private boolean isPointInLineArea(Point p) {
            int[] poly_x = new int[4];
            int[] poly_y = new int[4];
            switch (this.getQuadrant()) {
                case 1: {
                    poly_x[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[0] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[1] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_x[3] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[2] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    break;
                }
                case 2: {
                    poly_x[0] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[1] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[0] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[1] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_x[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    break;
                }
                case 3: {
                    poly_x[0] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[1] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_x[3] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[2] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[3] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[2] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    break;
                }
                case 4: {
                    poly_x[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[0] = this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[1] = this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_x[3] = this.getSize().width - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_x[2] = this.getSize().width - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    poly_y[3] = this.getSize().height - this.m1_arrowHeadBuffer - this.m1_lineAreaWidth;
                    poly_y[2] = this.getSize().height - this.m1_arrowHeadBuffer + this.m1_lineAreaWidth;
                    break;
                }
            }
            Polygon bounds = new Polygon(poly_x, poly_y, 4);
            return bounds.contains(p);
        }

        private void calcTheta() {
            int x = this.getXlen();
            int y = this.getYlen();
            if (x == 0) {
                this.m1_theta = y > 0 ? 1.5707963267948966 : 4.71238898038469;
            } else {
                this.m1_theta = Math.atan((double)y / (double)x);
                switch (this.getQuadrant()) {
                    case 2: 
                    case 3: {
                        this.m1_theta += Math.PI;
                        break;
                    }
                    case 4: {
                        this.m1_theta += Math.PI * 2;
                        break;
                    }
                }
            }
        }

        public Point getStart() {
            return this.m1_start;
        }

        public Point getFinish() {
            return this.m1_finish;
        }

        private int getXlen() {
            return this.m1_finish.x - this.m1_start.x;
        }

        private int getYlen() {
            return this.m1_finish.y - this.m1_start.y;
        }

        private class MFPArrowHead {
            private Polygon m2_arrowHead;
            private double m2_len;
            private boolean m2_filled;
            private boolean m2_finish;
            private int m2_arrowHeadBuffer;

            public MFPArrowHead(double len, boolean filled, boolean finish) {
                this.m2_len = len;
                this.m2_filled = filled;
                this.m2_finish = finish;
                this.m2_arrowHeadBuffer = (int)Math.ceil(this.m2_len * Math.tan(MFPArrow.this.m1_alpha));
            }

            public int getArrowHeadBuffer() {
                return this.m2_arrowHeadBuffer;
            }

            public void recalculateArea() {
                Point pt = null;
                if (this.m2_finish) {
                    switch (MFPArrow.this.getQuadrant()) {
                        case 1: {
                            pt = new Point(MFPArrow.this.getSize().width - this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                            break;
                        }
                        case 2: {
                            pt = new Point(this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                            break;
                        }
                        case 3: {
                            pt = new Point(this.m2_arrowHeadBuffer, MFPArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                            break;
                        }
                        case 4: {
                            pt = new Point(MFPArrow.this.getSize().width - this.m2_arrowHeadBuffer, MFPArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                            break;
                        }
                    }
                } else {
                    switch (MFPArrow.this.getQuadrant()) {
                        case 1: {
                            pt = new Point(this.m2_arrowHeadBuffer, MFPArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                            break;
                        }
                        case 2: {
                            pt = new Point(MFPArrow.this.getSize().width - this.m2_arrowHeadBuffer, MFPArrow.this.getSize().height - this.m2_arrowHeadBuffer);
                            break;
                        }
                        case 3: {
                            pt = new Point(MFPArrow.this.getSize().width - this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                            break;
                        }
                        case 4: {
                            pt = new Point(this.m2_arrowHeadBuffer, this.m2_arrowHeadBuffer);
                            break;
                        }
                    }
                }
                double cosA = Math.cos(MFPArrow.this.m1_alpha);
                int[] xs = new int[]{pt.x, this.addOrSubtract(!this.m2_finish, pt.x, (int)(this.m2_len / Math.cos(MFPArrow.this.m1_alpha) * Math.cos(MFPArrow.this.m1_theta - MFPArrow.this.m1_alpha))), this.addOrSubtract(!this.m2_finish, pt.x, (int)(this.m2_len * Math.cos(MFPArrow.this.m1_theta))), this.addOrSubtract(!this.m2_finish, pt.x, (int)(this.m2_len / Math.cos(MFPArrow.this.m1_alpha) * Math.cos(MFPArrow.this.m1_theta + MFPArrow.this.m1_alpha)))};
                int[] ys = new int[]{pt.y, this.addOrSubtract(!this.m2_finish, pt.y, (int)(this.m2_len / Math.cos(MFPArrow.this.m1_alpha) * Math.sin(MFPArrow.this.m1_theta - MFPArrow.this.m1_alpha))), this.addOrSubtract(!this.m2_finish, pt.y, (int)(this.m2_len * Math.sin(MFPArrow.this.m1_theta))), this.addOrSubtract(!this.m2_finish, pt.y, (int)(this.m2_len / Math.cos(MFPArrow.this.m1_alpha) * Math.sin(MFPArrow.this.m1_theta + MFPArrow.this.m1_alpha)))};
                this.m2_arrowHead = new Polygon(xs, ys, 4);
            }

            public void drawYourself(Graphics g) {
                if (this.m2_filled) {
                    g.fillPolygon(this.m2_arrowHead);
                } else {
                    g.drawPolygon(this.m2_arrowHead);
                }
            }

            public boolean contains(Point p1) {
                return this.m2_arrowHead.contains(p1);
            }

            public boolean contains(int x, int y) {
                return this.m2_arrowHead.contains(x, y);
            }

            private int addOrSubtract(boolean add, int a, int b) {
                return add ? a + b : a - b;
            }
        }
    }

    class MFPComponent
    extends JComponent {
        MFPComponent() {
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 500: {
                    this.requestFocus();
                    break;
                }
                default: {
                    super.processMouseEvent(e);
                }
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            switch (e.getKeyChar()) {
                case '\u007f': {
                    MultiFunctionPanel.this.requestFocus();
                    MultiFunctionPanel.this.remove(this);
                    break;
                }
                default: {
                    super.processKeyEvent(e);
                }
            }
        }
    }
}

