/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.Application;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.HasNextPages;
import jas2.util.JASWizardPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EtchedBorder;

public class JASWizard
extends JDialog
implements ActionListener {
    private final JFrame m_frame;
    private final Cursor m_default = Cursor.getDefaultCursor();
    private final Cursor m_wait = new Cursor(3);
    private boolean m_currentPageHasAmbiguousDefault;
    private final JRootPane m_rootPane;
    private final Container m_contentPane;
    private final JPanel m_wizardPagePanel;
    private final JASWizardPage m_firstPage;
    private JASWizardPage m_currentPage;
    private final JButton m_cancel;
    private final JButton m_help;
    private final JButton m_prev;
    private final JButton m_next;
    private final JButton m_finish;
    private final CardLayout m_layout;

    public JASWizard(JFrame parent, String title, JASWizardPage firstPage) {
        super(parent, title, true);
        this.m_frame = parent;
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_rootPane = this.getRootPane();
        this.m_layout = new CardLayout();
        this.m_wizardPagePanel = new JPanel(this.m_layout);
        firstPage.addTo(this.m_wizardPagePanel, this, null);
        JPanel buttons = new JPanel(new FlowLayout());
        this.m_cancel = new JButton("Cancel");
        buttons.add(this.m_cancel);
        this.m_cancel.setMnemonic('C');
        this.m_help = new JButton("Help");
        buttons.add(this.m_help);
        this.m_help.setMnemonic('H');
        this.m_prev = new JButton("<< Previous");
        buttons.add(this.m_prev);
        this.m_prev.setMnemonic('P');
        this.m_next = new JButton("Next >>");
        buttons.add(this.m_next);
        this.m_next.setMnemonic('N');
        this.m_finish = new JButton("Finish");
        buttons.add(this.m_finish);
        this.m_finish.setMnemonic('F');
        this.m_wizardPagePanel.setBorder(new EtchedBorder());
        this.m_contentPane.add("Center", this.m_wizardPagePanel);
        this.m_contentPane.add("South", buttons);
        this.pack();
        Dimension mySize = this.getSize();
        Dimension parentSize = parent.getSize();
        Point position = parent.getLocation();
        position.translate((parentSize.width - mySize.width) / 2, (parentSize.height - mySize.height) / 2);
        this.setLocation(position);
        this.m_layout.first(this.m_wizardPagePanel);
        this.m_currentPage = this.m_firstPage = firstPage;
        this.m_firstPage.doEnable();
        this.m_cancel.addActionListener(this);
        this.m_help.addActionListener(this);
        this.m_prev.addActionListener(this);
        this.m_next.addActionListener(this);
        this.m_finish.addActionListener(this);
        this.m_currentPageHasAmbiguousDefault = this.m_currentPage.isFinishable() && this.m_currentPage.hasNextPages();
        this.m_help.setEnabled(firstPage instanceof HasHelpPage);
        this.setResizable(false);
        this.enableEvents(64L);
        firstPage.beforeShowing();
        Application app = Application.getApplication();
        if (app != null) {
            app.modalDialogOpening(this);
        }
        this.show();
        if (app != null) {
            app.modalDialogClosing(this);
        }
    }

    void setNextEnabled(boolean b) {
        this.m_next.setEnabled(b && this.m_currentPage.hasNextPages());
    }

    void setFinishEnabled(boolean b) {
        this.m_finish.setEnabled(b && this.m_currentPage.isFinishable());
    }

    void doPrevEnabled() {
        this.m_prev.setEnabled(this.m_currentPage.getPrev() != null);
    }

    private void onHelp() {
        this.setToWaitCursor();
        HasHelpPage h = (HasHelpPage)((Object)this.m_currentPage);
        Application.getApplication().showHelpTopic(h.getHelpTopic(), this);
        this.setToDefaultCursor();
    }

    private void setToCurrentPage(JASWizardPage page) {
        this.m_currentPage = page;
        this.m_currentPageHasAmbiguousDefault = this.m_currentPage.isFinishable() && this.m_currentPage.hasNextPages();
        page.doEnable();
        if (!this.m_currentPageHasAmbiguousDefault) {
            this.setDefaultButton();
        }
        this.m_help.setEnabled(page instanceof HasHelpPage);
        page.beforeShowing();
        this.m_layout.show(this.m_wizardPagePanel, page.toString());
    }

    private void onPrev() {
        this.setToWaitCursor();
        try {
            this.setToCurrentPage(this.m_currentPage.getPrev());
        }
        catch (Throwable t) {
            this.handleError("Error during wizard processing", t);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    private void onNext() {
        this.setToWaitCursor();
        try {
            JASWizardPage newPage = ((HasNextPages)((Object)this.m_currentPage)).getNext();
            if (newPage != null) {
                if (!this.m_wizardPagePanel.isAncestorOf(newPage)) {
                    newPage.addTo(this.m_wizardPagePanel, this, this.m_currentPage);
                    newPage.invalidate();
                    this.validate();
                }
                this.setToCurrentPage(newPage);
            }
        }
        catch (Throwable t) {
            this.handleError("Error during wizard processing", t);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    void setDefaultButton() {
        if (this.m_currentPageHasAmbiguousDefault && this.m_next.isEnabled()) {
            this.m_rootPane.setDefaultButton(this.m_next);
        } else if (this.m_currentPageHasAmbiguousDefault && this.m_finish.isEnabled()) {
            this.m_rootPane.setDefaultButton(this.m_finish);
        } else {
            this.m_rootPane.setDefaultButton(this.m_currentPage.hasNextPages() ? this.m_next : this.m_finish);
        }
    }

    @Override
    public void dispose() {
        this.m_firstPage.clear();
        JASWizardPage.pageNumber = 0;
        if (this.getCursor() == this.m_wait) {
            this.m_frame.setCursor(this.m_wait);
        }
        super.dispose();
    }

    private void onFinish() {
        this.setToWaitCursor();
        try {
            ((Finishable)((Object)this.m_currentPage)).onFinish();
        }
        catch (Throwable t) {
            this.handleError("Error during wizard processing", t);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    private void onCancel() {
        this.setToWaitCursor();
        try {
            this.m_firstPage.doCancel();
            this.dispose();
        }
        catch (Throwable t) {
            this.handleError("Error during wizard processing", t);
        }
        finally {
            this.setToDefaultCursor();
        }
    }

    void setToWaitCursor() {
        this.setCursor(this.m_wait);
    }

    void setToDefaultCursor() {
        this.setCursor(this.m_default);
        this.m_frame.setCursor(this.m_default);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_cancel) {
            this.onCancel();
        } else if (source == this.m_help) {
            this.onHelp();
        } else if (source == this.m_prev) {
            this.onPrev();
        } else if (source == this.m_next) {
            this.onNext();
        } else if (source == this.m_finish) {
            this.onFinish();
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        int id = e.getID();
        if (id == 201) {
            this.onCancel();
        } else if (id == 205) {
            this.setDefaultButton();
        }
    }

    protected void handleError(String message, Throwable t) {
        Application app = Application.getApplication();
        if (app != null) {
            app.error("Error during wizard processing", t);
        } else {
            t.printStackTrace();
        }
    }
}

