/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.CommandProcessor;
import jas2.util.CommandSource;
import jas2.util.CommandTarget;
import java.util.Enumeration;
import java.util.Observer;
import java.util.Vector;

public final class CommandTargetManager {
    private boolean started = false;
    private final Vector processors = new Vector();
    private final Vector sources = new Vector();

    public synchronized void add(CommandProcessor processor) {
        this.processors.addElement(processor);
        if (this.started) {
            Enumeration es = this.sources.elements();
            while (es.hasMoreElements()) {
                String command;
                CommandTarget target;
                CommandSource s = (CommandSource)es.nextElement();
                if (s.getTarget() != null || (target = processor.acceptCommand(command = s.getCommand())) == null || !s.setTarget(target) || !(s instanceof Observer)) continue;
                processor.addObserver((Observer)((Object)s));
            }
        }
        processor.setManager(this);
    }

    public synchronized void remove(CommandProcessor processor) {
        this.processors.removeElement(processor);
        if (this.started) {
            Enumeration es = this.sources.elements();
            while (es.hasMoreElements()) {
                CommandSource s = (CommandSource)es.nextElement();
                CommandTarget target = s.getTarget();
                if (target == null || target.getProcessor() != processor) continue;
                s.clearTarget();
                if (!(s instanceof Observer)) continue;
                processor.deleteObserver((Observer)((Object)s));
            }
        }
        processor.setManager(null);
    }

    public synchronized void add(CommandSource source) {
        this.sources.addElement(source);
        if (this.started) {
            this.linkCommandSource(source);
        }
    }

    public synchronized void remove(CommandSource source) {
        this.sources.removeElement(source);
        String command = source.getCommand();
        Enumeration ep = this.processors.elements();
        while (ep.hasMoreElements()) {
            CommandProcessor p = (CommandProcessor)ep.nextElement();
            CommandTarget t = p.acceptCommand(command);
            if (t == null) continue;
            source.clearTarget();
            if (!(source instanceof Observer)) continue;
            p.deleteObserver((Observer)((Object)source));
        }
    }

    public synchronized void start() {
        this.started = true;
        Enumeration es = this.sources.elements();
        while (es.hasMoreElements()) {
            this.linkCommandSource((CommandSource)es.nextElement());
        }
    }

    private void linkCommandSource(CommandSource s) {
        String command = s.getCommand();
        Enumeration ep = this.processors.elements();
        while (ep.hasMoreElements()) {
            CommandProcessor p = (CommandProcessor)ep.nextElement();
            CommandTarget t = p.acceptCommand(command);
            if (t == null || !s.setTarget(t) || !(s instanceof Observer)) continue;
            p.addObserver((Observer)((Object)s));
        }
    }
}

