/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.ColorChooser;
import jas2.util.ColorEvent;
import jas2.util.ColorListener;
import jas2.util.FieldBinding;
import jas2.util.UnsupportedType;
import java.awt.Color;

class ColorFieldBinding
extends FieldBinding
implements ColorListener {
    private Color m_oldVal = Color.black;
    private ColorChooser m_field;

    ColorFieldBinding(ColorChooser field) {
        this.m_field = field;
        field.addColorListener(this);
    }

    @Override
    void set(Object value) throws UnsupportedType {
        if (!(value instanceof Color)) {
            throw new UnsupportedType(this.m_field, value.getClass());
        }
        Color c = (Color)value;
        if (!this.m_oldVal.equals(c)) {
            this.m_field.setColor(c);
            this.m_oldVal = c;
        }
    }

    @Override
    Object get(Class type) throws UnsupportedType {
        Color c = this.m_field.getColor();
        if (!type.isInstance(c)) {
            throw new UnsupportedType(this.m_field, type);
        }
        return c;
    }

    @Override
    public void colorChanged(ColorEvent e) {
        Color c = this.m_field.getColor();
        if (c != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getColor();
    }
}

