/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import hepjas.analysis.EventAnalyzer;
import hepjas.analysis.EventData;
import hepjas.analysis.NTupleEventData;
import hepjas.analysis.ScatterPlot;
import jas2.tuple.CutModel;
import jas2.tuple.TupleColumn;
import jas2.tuple.TupleModel;

class ScatterModel
extends TupleModel {
    private ScatterPlot m_scat = new ScatterPlot("test");
    private static String[] rows = new String[]{"X-Axis", "Y-Axis"};
    private static int[] defaults = new int[]{0, 1};

    ScatterPlot getScatterPlot() {
        return this.m_scat;
    }

    EventAnalyzer getEventAnalyzer(CutModel cutModel) {
        return new Analyzer(this.getValue(0), this.getValue(1), this.m_scat, cutModel);
    }

    ScatterModel(TupleColumn[] tupleColumns) {
        super(rows, defaults, tupleColumns);
    }

    public String toString() {
        return "Scatter Plot";
    }

    class Analyzer
    extends EventAnalyzer {
        private int xCol;
        private int yCol;
        private ScatterPlot scat;
        private CutModel cutModel;

        Analyzer(int xCol, int yCol, ScatterPlot scat, CutModel cutModel) {
            this.xCol = xCol;
            this.yCol = yCol;
            this.scat = scat;
            this.cutModel = cutModel;
        }

        @Override
        public void processEvent(EventData d) {
            NTupleEventData data = (NTupleEventData)d;
            int rows = this.cutModel.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (!this.cutModel.isEnabled(i) || this.cutModel.getCut(i).apply(data)) continue;
                return;
            }
            this.scat.fill(data.getDouble(this.xCol), data.getDouble(this.yCol));
        }
    }
}

