/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.job.LoaderException;
import jas2.loader.ClassPathLoader;
import jas2.swingstudio.BuiltInCompiler;
import jas2.swingstudio.ChangableContainer;
import jas2.swingstudio.Closable;
import jas2.swingstudio.FileError;
import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JASClassPath;
import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JASException;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASWindowManager;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.ProgramPagePopupMenu;
import jas2.swingstudio.ProgramTextArea;
import jas2.util.CommandProcessor;
import jas2.util.FileTypeFileFilter;
import jas2.util.JASDialog;
import jas2.util.JASState;
import jas2.util.JASTextField;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.gjt.sp.jedit.syntax.DefaultSyntaxDocument;

final class ProgramPage
extends JScrollPane
implements ChangeListener,
DocumentListener,
HasCommandProcessor,
Externalizable,
ChangableContainer,
ActionListener,
Closable {
    static final long serialVersionUID = -4186647674998093369L;
    private DefaultSyntaxDocument d;
    private ProgramTextPage text;
    private File f;
    private String m_name;
    private boolean m_isCompiled = false;
    private boolean isChanged;
    private boolean m_hasChangedSinceLastBackup;
    private ProgramCommandProcessor commandProcessor;
    private static Timer backupTimer = null;
    private static final String backupInterval_Key = "BackupInterval";
    private static final String backupDirectory_Key = "BackupDir";
    private static final String isRunning_Key = "RunTimedBackup";
    private static final String leftMargin_Key = "left";
    private static final String rightMargin_Key = "right";
    private static final String topMargin_Key = "top";
    private static final String bottomMargin_Key = "bottom";
    private static final Vector m_instances = new Vector();
    private final Dimension m_preferredSize = new Dimension(50, 50);

    public ProgramPage() {
        this.init(true);
        ProgramPage.setTabSizeProperty((DefaultSyntaxDocument)this.getText().getDocument(), ProgramPage.getTabSize());
    }

    ProgramPage(File f) throws FileError {
        this.init(false);
        try {
            this.text.read(new FileReader(f), (Object)f);
            this.d = (DefaultSyntaxDocument)this.text.getDocument();
            this.d.addDocumentListener(this);
            this.text.setStyles();
            this.f = f;
            this.isChanged = false;
            this.m_hasChangedSinceLastBackup = false;
            String name = f.getName();
            this.setClassName(name.substring(0, name.length() - 5));
            ProgramPage.setTabSizeProperty((DefaultSyntaxDocument)this.getText().getDocument(), ProgramPage.getTabSize());
        }
        catch (IOException ex) {
            throw new FileError("Could not load file: " + f.getName(), ex);
        }
    }

    public DefaultSyntaxDocument getDefaultSyntaxDocument() {
        return this.d;
    }

    String getCanonicalPath() {
        try {
            return this.f.getCanonicalPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void init(boolean callSetStyles) {
        if (backupTimer == null) {
            backupTimer = new Timer(ProgramPage.getBackupInterval(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            backupTimer.setInitialDelay(0);
            if (ProgramPage.timerIsRunning()) {
                backupTimer.start();
            }
        }
        this.text = new ProgramTextPage();
        this.setViewportView(this.text);
        this.text.getDocument().addDocumentListener(this);
        this.text.getCaret().addChangeListener(this);
        if (callSetStyles) {
            this.text.setStyles();
        }
        this.isChanged = false;
        this.m_hasChangedSinceLastBackup = false;
        this.commandProcessor = new ProgramCommandProcessor();
    }

    private boolean classExists() {
        try {
            ClassPathLoader loader = new ClassPathLoader(JASClassPath.create(), "ProgramLoader");
            byte[] data = loader.loadClassData(this.m_name);
            return true;
        }
        catch (ClassNotFoundException x) {
            return false;
        }
    }

    private String getPackage() {
        String text = this.text.getText();
        int index = text.indexOf("package");
        if (index != -1) {
            char c;
            index += 7;
            while (Character.isWhitespace(text.charAt(index))) {
                ++index;
            }
            int endIndex = index;
            while ((c = text.charAt(endIndex)) != ';' && !Character.isWhitespace(c)) {
                ++endIndex;
            }
            return text.substring(index, endIndex) + ".";
        }
        return "";
    }

    void setClassName(String name) {
        this.m_name = this.getPackage().concat(name);
    }

    static int getBackupInterval() {
        return JavaAnalysisStudio.getApp().getUserProperties().getInteger(backupInterval_Key, 300000);
    }

    static void setBackupInterval(int i) {
        JavaAnalysisStudio.getApp().getUserProperties().setInteger(backupInterval_Key, i);
        if (backupTimer != null && i != backupTimer.getDelay()) {
            backupTimer.setDelay(i);
        }
    }

    static boolean timerIsRunning() {
        return JavaAnalysisStudio.getApp().getUserProperties().getBoolean(isRunning_Key, false);
    }

    static void setTimerIsRunning(boolean b) {
        JavaAnalysisStudio.getApp().getUserProperties().setBoolean(isRunning_Key, b);
        if (backupTimer == null) {
            return;
        }
        if (backupTimer.isRunning()) {
            if (!b) {
                backupTimer.stop();
            }
        } else if (b) {
            backupTimer.start();
        }
    }

    static String getBackupDirectory() {
        return JavaAnalysisStudio.getApp().getUserProperties().getString(backupDirectory_Key, "backup" + File.separator);
    }

    static void setBackupDirectory(String s) {
        JavaAnalysisStudio.getApp().getUserProperties().setString(backupDirectory_Key, s);
    }

    @Override
    public void removeNotify() {
        m_instances.removeElement(this);
        super.removeNotify();
        backupTimer.removeActionListener(this);
    }

    @Override
    public void addNotify() {
        m_instances.addElement(this);
        super.addNotify();
        backupTimer.addActionListener(this);
    }

    @Override
    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @Override
    public boolean hasChanged() {
        return this.isChanged;
    }

    void setFile(File f) {
        this.f = f;
        this.isChanged = false;
        this.m_hasChangedSinceLastBackup = false;
    }

    ProgramTextArea getText() {
        return this.text;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            int p = this.text.getCaretPosition();
            Rectangle r = this.text.modelToView(p);
            int y = 1 + r.y / this.text.getGraphics().getFontMetrics().getHeight();
            JavaAnalysisStudio.getApp().setMessage("Line " + y);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.commandProcessor.setChanged();
    }

    private void setChanged(boolean changed) {
        this.isChanged = this.m_hasChangedSinceLastBackup = changed;
        this.commandProcessor.setChanged();
    }

    @Override
    public void writeExternal(ObjectOutput p) throws IOException {
        p.writeObject(this.m_name);
        if (this.f != null) {
            if (this.isChanged) {
                this.commandProcessor.onSave();
            }
            p.writeObject(this.f);
        } else {
            p.writeObject(this.text.getText());
            p.writeBoolean(this.isChanged);
        }
    }

    @Override
    public void readExternal(ObjectInput p) throws IOException, ClassNotFoundException {
        this.init(false);
        this.m_name = (String)p.readObject();
        Object o = p.readObject();
        if (o instanceof File) {
            this.f = (File)o;
            this.text.read(new FileReader(this.f), (Object)this.f);
            this.text.getDocument().addDocumentListener(this);
            this.isChanged = false;
            this.m_hasChangedSinceLastBackup = false;
        } else {
            this.f = null;
            this.text.setText((String)o);
            this.isChanged = p.readBoolean();
        }
        this.text.setStyles();
    }

    void setText(String s) {
        this.text.setText(s);
    }

    @Override
    public void pageSelected(boolean state) {
    }

    @Override
    public boolean pleaseClose() throws JASException {
        try {
            if (!this.isChanged) {
                return true;
            }
            String name = this.f == null ? "Untitled" : this.f.getName();
            int rc = JOptionPane.showConfirmDialog(this, "Save changes to file " + name + "?", "Save Changes?", 1, 2);
            if (rc == 0) {
                return this.save();
            }
            return rc == 1;
        }
        catch (IOException x) {
            throw new JASException("Error saving file", x);
        }
    }

    private synchronized boolean save() throws IOException {
        if (this.f == null) {
            return this.saveAs();
        }
        try {
            FileWriter w = new FileWriter(this.f);
            this.text.write(w);
            w.close();
            this.isChanged = false;
            this.m_hasChangedSinceLastBackup = false;
            JavaAnalysisStudio.getApp().updateRecentFiles(this.f);
            String name = this.f.getName();
            this.setClassName(name.substring(0, name.length() - 5));
            return true;
        }
        catch (FileNotFoundException x) {
            throw new IOException("Could not save file (not writable?)");
        }
    }

    private synchronized boolean saveAs() throws IOException {
        JFileChooser dlg = new JFileChooser(JavaAnalysisStudio.getApp().getUserProperties().getString("LastProgramPath", System.getProperty("user.home")));
        dlg.setSelectedFile(new File(this.m_name.concat(".java")));
        dlg.setFileFilter(new FileTypeFileFilter("java", "Java File (*.java)"));
        dlg.setDialogTitle("Save Source File As...");
        if (dlg.showSaveDialog(this) == 0) {
            File f = dlg.getSelectedFile();
            if (!f.getName().endsWith(".java")) {
                f = new File(f.getAbsolutePath().concat(".java"));
            }
            JavaAnalysisStudio.getApp().getWindowManager().setCurrentTitle(f.getName());
            JavaAnalysisStudio.getApp().getUserProperties().setString("LastProgramPath", f.getParent());
            try {
                FileWriter w = new FileWriter(f);
                this.text.write(w);
                w.close();
                this.f = f;
                this.isChanged = false;
                this.m_hasChangedSinceLastBackup = false;
                JavaAnalysisStudio.getApp().updateRecentFiles(f);
                String name = f.getName();
                this.setClassName(name.substring(0, name.length() - 5));
                return true;
            }
            catch (FileNotFoundException x) {
                throw new IOException("Could not save file (not writable?)");
            }
        }
        return false;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        if (!this.m_hasChangedSinceLastBackup) {
            return;
        }
        File backupFile = new File(ProgramPage.getBackupDirectory(), (this.f == null ? String.valueOf(this.hashCode()) : this.f.getName()) + ".bk");
        FileWriter w = null;
        try {
            w = new FileWriter(backupFile);
            this.text.write(w);
            w.close();
            System.out.println("saved backup file " + backupFile.getAbsolutePath());
            this.m_hasChangedSinceLastBackup = false;
        }
        catch (Exception x) {
            ProgramPage.setTimerIsRunning(false);
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            JavaAnalysisStudio.getApp().error("Timed backup failed and has been stopped.", x, "jobs.eventAnalysisAndGeneration.timedBackup");
        }
    }

    private static void setTabSizeProperty(DefaultSyntaxDocument d, int ts) {
        d.putProperty("tabSize", new Integer(ts));
    }

    public static void setTabSize(int ts) {
        if (m_instances.size() == 0) {
            return;
        }
        Enumeration e = m_instances.elements();
        while (e.hasMoreElements()) {
            try {
                ProgramPage p = (ProgramPage)e.nextElement();
                ProgramPage.setTabSizeProperty((DefaultSyntaxDocument)p.getText().getDocument(), ts);
            }
            catch (Exception exception) {}
        }
        JavaAnalysisStudio.getApp().getUserProperties().setInteger("tabSize", ts);
    }

    public static int getTabSize() {
        return JavaAnalysisStudio.getApp().getUserProperties().getInteger("tabSize", 4);
    }

    static void updateInstanceFonts() {
        if (m_instances.size() == 0) {
            return;
        }
        Font newFont = new Font(ProgramTextArea.getDisplayFont(), ProgramTextArea.getFontStyle(), ProgramTextArea.getFontSize());
        Enumeration e = m_instances.elements();
        while (e.hasMoreElements()) {
            ProgramPage p = (ProgramPage)e.nextElement();
            p.getText().setFont(newFont);
            p.repaint();
        }
    }

    static void updateInstanceStyles() {
        if (m_instances.size() == 0) {
            return;
        }
        Enumeration e = m_instances.elements();
        while (e.hasMoreElements()) {
            ProgramPage p = (ProgramPage)e.nextElement();
            p.getText().setStyles();
            p.repaint();
        }
    }

    static float getRightMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(rightMargin_Key, 0.5f);
    }

    static void setRightMargin(float d) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(rightMargin_Key, d);
    }

    static float getTopMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(topMargin_Key, 0.5f);
    }

    static void setTopMargin(float d) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(topMargin_Key, d);
    }

    static float getBottomMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(bottomMargin_Key, 0.5f);
    }

    static void setBottomMargin(float d) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(bottomMargin_Key, d);
    }

    static float getLeftMargin() {
        return JavaAnalysisStudio.getApp().getUserProperties().getFloat(leftMargin_Key, 0.5f);
    }

    static void setLeftMargin(float d) {
        JavaAnalysisStudio.getApp().getUserProperties().setFloat(leftMargin_Key, d);
    }

    public final class ProgramTextPage
    extends ProgramTextArea {
        ProgramTextPage() {
            super(true);
            this.enableEvents(16L);
            this.addKeyListener(new KL());
        }

        public void setTabSize(int ts) {
            try {
                ((DefaultSyntaxDocument)ProgramPage.this.text.getDocument()).putProperty("tabSize", new Integer(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            JavaAnalysisStudio.getApp().getUserProperties().setInteger("tabSize", ts);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.isPopupTrigger()) {
                Container c;
                int x = e.getX();
                int y = e.getY();
                y -= ProgramPage.this.getViewport().getViewPosition().y;
                Container frame = SwingUtilities.getAncestorOfClass(JInternalFrame.class, c);
                if (frame != null) {
                    Container parent = frame.getParent();
                    for (c = ProgramPage.this; c != parent; c = c.getParent()) {
                        Point p = c.getLocation();
                        x += p.x;
                        y += p.y;
                    }
                }
                JASJob job = JavaAnalysisStudio.getApp().getJob();
                if (!ProgramPage.this.m_isCompiled && ProgramPage.this.classExists()) {
                    ProgramPage.this.m_isCompiled = true;
                }
                JavaAnalysisStudio.getApp().getCommandManager().add(ProgramPage.this.commandProcessor);
                ProgramPagePopupMenu popup = new ProgramPagePopupMenu();
                popup.willBecomeVisible(ProgramPage.this.m_name, ProgramPage.this.m_name != null && job != null && ProgramPage.this.m_isCompiled && !job.isLoaded(ProgramPage.this.m_name));
                JASWindowManager winman = (JASWindowManager)SwingUtilities.getAncestorOfClass(JASWindowManager.class, this);
                if (winman != null) {
                    winman.modifyPopupMenu(popup, c);
                }
                popup.show(c, x, y);
            }
        }

        void gotoLine(int line) {
            this.setCaretPosition(this.viewToModel(new Point(0, this.getGraphics().getFontMetrics().getHeight() * (line - 1))));
        }

        private void setLeadingTabsForClosingBrace(int caret) {
            try {
                Character c;
                int i;
                int originalCaretPos = caret;
                Element map = this.getDocument().getDefaultRootElement();
                int index = map.getElementIndex(caret);
                Element lineElement = map.getElement(index);
                int start = lineElement.getStartOffset();
                int end = lineElement.getEndOffset();
                int lineLength = end - start - 1;
                String theOriginalLine = this.getDocument().getText(start, lineLength);
                for (int i2 = 0; i2 < caret - start; ++i2) {
                    if (Character.isWhitespace(theOriginalLine.charAt(i2))) continue;
                    return;
                }
                String theTrimmedLine = theOriginalLine.trim();
                this.getDocument().remove(start, lineLength);
                this.getDocument().insertString(start, theTrimmedLine, null);
                caret = start;
                this.indentLine(caret);
                lineElement = map.getElement(index);
                start = lineElement.getStartOffset();
                end = lineElement.getEndOffset();
                lineLength = end - start - 1;
                String theIndentedLine = this.getDocument().getText(start, lineLength);
                for (i = 0; i < theIndentedLine.length() && (c = new Character(theIndentedLine.charAt(i))).equals(new Character('\t')); ++i) {
                }
                caret = start + i;
                if (i > 0) {
                    this.getDocument().remove(caret - 1, 1);
                    this.setCaretPosition(caret - 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean indentLine(int caret) {
            String openBrackets = "{";
            String closeBrackets = "}";
            int tabSize = ProgramPage.getTabSize();
            boolean noTabs = false;
            try {
                Element map = this.getDocument().getDefaultRootElement();
                int index = map.getElementIndex(caret);
                if (index == 0) {
                    return false;
                }
                Element lineElement = map.getElement(index);
                Element prevLineElement = null;
                int prevStart = 0;
                int prevEnd = 0;
                while (--index >= 0) {
                    prevLineElement = map.getElement(index);
                    prevStart = prevLineElement.getStartOffset();
                    prevEnd = prevLineElement.getEndOffset();
                    if (prevEnd - prevStart <= 1) continue;
                }
                if (prevLineElement == null) {
                    return false;
                }
                int start = lineElement.getStartOffset();
                int end = lineElement.getEndOffset();
                String line = this.getDocument().getText(start, end - start);
                String prevLine = this.getDocument().getText(prevStart, prevEnd - prevStart);
                boolean prevLineStart = true;
                int prevLineIndent = 0;
                int prevLineBrackets = 0;
                block11: for (int i = 0; i < prevLine.length(); ++i) {
                    char c = prevLine.charAt(i);
                    switch (c) {
                        case ' ': {
                            if (!prevLineStart) continue block11;
                            ++prevLineIndent;
                            continue block11;
                        }
                        case '\t': {
                            if (!prevLineStart) continue block11;
                            prevLineIndent += tabSize - prevLineIndent % tabSize;
                            continue block11;
                        }
                        default: {
                            prevLineStart = false;
                            if (closeBrackets.indexOf(c) != -1) {
                                prevLineBrackets = Math.max(prevLineBrackets - 1, 0);
                                continue block11;
                            }
                            if (openBrackets.indexOf(c) == -1) continue block11;
                            ++prevLineBrackets;
                        }
                    }
                }
                boolean lineStart = true;
                int lineIndent = 0;
                int lineWidth = 0;
                int lineBrackets = 0;
                int lineOpenBrackets = 0;
                block12: for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    switch (c) {
                        case ' ': {
                            if (!lineStart) continue block12;
                            ++lineIndent;
                            ++lineWidth;
                            continue block12;
                        }
                        case '\t': {
                            if (!lineStart) continue block12;
                            lineIndent += tabSize - lineIndent % tabSize;
                            ++lineWidth;
                            continue block12;
                        }
                        default: {
                            lineStart = false;
                            if (closeBrackets.indexOf(c) != -1) {
                                if (lineOpenBrackets != 0) {
                                    --lineOpenBrackets;
                                    continue block12;
                                }
                                --lineBrackets;
                                continue block12;
                            }
                            if (openBrackets.indexOf(c) == -1) continue block12;
                            ++lineOpenBrackets;
                        }
                    }
                }
                if (lineIndent >= (prevLineIndent += (prevLineBrackets + lineBrackets) * tabSize)) {
                    return false;
                }
                this.getDocument().remove(start, lineWidth);
                this.getDocument().insertString(start, this.createWhiteSpace(prevLineIndent, tabSize, noTabs), null);
                return true;
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
                return false;
            }
        }

        public String createWhiteSpace(int len, int tabSize, boolean noTabs) {
            StringBuffer buf = new StringBuffer();
            if (noTabs) {
                while (len-- > 0) {
                    buf.append(' ');
                }
            } else {
                int count = len / tabSize;
                while (count-- > 0) {
                    buf.append('\t');
                }
                count = len % tabSize;
                while (count-- > 0) {
                    buf.append(' ');
                }
            }
            return buf.toString();
        }

        class KL
        extends KeyAdapter {
            KL() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int selStart = ProgramTextPage.this.getSelectionStart();
                int selEnd = ProgramTextPage.this.getSelectionEnd();
                boolean consumeIt = false;
                switch (e.getKeyCode()) {
                    case 10: {
                        ProgramTextPage.this.replaceSelection("\n");
                        if (selStart == selEnd) {
                            ProgramTextPage.this.indentLine(ProgramTextPage.this.getSelectionStart());
                        }
                        e.consume();
                        break;
                    }
                    case 9: {
                        if (selStart == selEnd) {
                            consumeIt = ProgramTextPage.this.indentLine(selStart);
                        }
                        if (!consumeIt) break;
                        e.consume();
                        break;
                    }
                    default: {
                        int caretPos;
                        if (!new Character(e.getKeyChar()).equals(new Character('}')) || (caretPos = ProgramTextPage.this.getCaretPosition()) <= 0) break;
                        ProgramTextPage.this.setLeadingTabsForClosingBrace(caretPos);
                        e.consume();
                    }
                }
            }
        }
    }

    private class CompileOutputProcessor
    extends Thread {
        private InputStream in;
        private OutputStream out;

        CompileOutputProcessor(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.start();
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[4096];
                int n = this.in.read(buffer);
                while (n >= 0) {
                    this.out.write(buffer, 0, n);
                    n = this.in.read(buffer);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ProgramCommandProcessor
    extends JASCommandProcessor {
        private final String m_showJDKWarningBox_Key = "ShowJDKWarningBox";

        private ProgramCommandProcessor() {
        }

        public void onSave() throws IOException {
            if (ProgramPage.this.save()) {
                this.setChanged();
            }
        }

        public void onSaveAs() throws IOException {
            if (ProgramPage.this.saveAs()) {
                this.setChanged();
            }
        }

        public void enableSave(JASState state) {
            state.setEnabled(ProgramPage.this.isChanged);
        }

        public void onGoToLine() {
            new JASDialog(JavaAnalysisStudio.getApp().getFrame(), "Go To Line..."){
                private JTextField m_line;

                @Override
                protected void onOK() {
                    try {
                        ProgramPage.this.text.gotoLine(Integer.parseInt(this.m_line.getText()));
                        super.onOK();
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(this, this.m_line.getText().concat(" is not a number."), "Number Format Exception", 0);
                    }
                }

                @Override
                public boolean doModal() {
                    this.m_line = new JASTextField(8);
                    try {
                        this.m_line.setText(String.valueOf(1 + ((ProgramPage)ProgramPage.this).text.modelToView((int)((ProgramPage)ProgramPage.this).text.getCaretPosition()).y / ProgramPage.this.text.getGraphics().getFontMetrics().getHeight()));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    Container c = this.getContentPane();
                    c.add("West", new JLabel("Enter line number: "));
                    c.add("East", this.m_line);
                    this.m_line.getDocument().addDocumentListener(this);
                    this.pack();
                    this.m_line.requestFocus();
                    return super.doModal();
                }
            }.doModal();
        }

        public void onPrint() {
            block13: {
                String fontName = ProgramTextArea.getPrintingFont();
                int fontStyle = ProgramTextArea.getPrintingFontStyle();
                int fontSize = ProgramTextArea.getPrintingFontSize();
                float leftMarginInInches = ProgramPage.getLeftMargin();
                float rightMarginInInches = ProgramPage.getRightMargin();
                float topMarginInInches = ProgramPage.getTopMargin();
                float bottomMarginInInches = ProgramPage.getBottomMargin();
                PrintJob pjob = ProgramPage.this.getToolkit().getPrintJob(JavaAnalysisStudio.getApp().getFrame(), "Java Analysis Studio", null);
                try {
                    if (pjob == null) break block13;
                    Graphics pg = pjob.getGraphics();
                    pg.setFont(new Font(fontName, fontStyle, fontSize));
                    int page_dpi = pjob.getPageResolution();
                    Dimension pageDimension = pjob.getPageDimension();
                    int rightMargin = (int)(((double)rightMarginInInches + 0.5) * (double)page_dpi);
                    int leftMargin = (int)(leftMarginInInches * (float)page_dpi);
                    int bottomMargin = (int)(((double)bottomMarginInInches + 0.5) * (double)page_dpi);
                    int topMargin = (int)(topMarginInInches * (float)page_dpi);
                    String originalText = ProgramPage.this.text.getText();
                    StringBuffer b = new StringBuffer(originalText.length() * 11 / 10);
                    int tabIndex = originalText.indexOf(9);
                    int startIndex = 0;
                    while (tabIndex >= 0) {
                        b.append(originalText.substring(startIndex, tabIndex));
                        b.append("    ");
                        startIndex = tabIndex + 1;
                        tabIndex = originalText.indexOf(9, startIndex);
                    }
                    b.append(originalText.substring(startIndex));
                    String text = b.toString();
                    FontMetrics fm = pg.getFontMetrics();
                    int lineHeight = fm.getHeight();
                    int pageBottom = pageDimension.height - bottomMargin;
                    int lineLength = pageDimension.width - rightMargin - leftMargin;
                    int initialLinePositionInY = topMargin + fm.getAscent();
                    if (pageBottom <= topMargin || lineLength <= 0) {
                        JOptionPane.showMessageDialog(JavaAnalysisStudio.getApp().getFrame(), "Page has negative or zero size.", "Error...", 0);
                        return;
                    }
                    int lineStartIndex = 0;
                    int lineEndIndex = 0;
                    char[] lineChars = new char[100];
                    while (true) {
                        int charsOnThisLine;
                        int linePositionInY;
                        try {
                            for (linePositionInY = initialLinePositionInY; linePositionInY < pageBottom; linePositionInY += lineHeight) {
                                int actualEnd;
                                char currentChar;
                                int lineLengthSoFar = 0;
                                while ((currentChar = text.charAt(lineEndIndex)) != '\n' && (lineLengthSoFar += fm.charWidth(currentChar)) <= lineLength) {
                                    ++lineEndIndex;
                                }
                                if (lineEndIndex == lineStartIndex && currentChar != '\n') {
                                    ++lineEndIndex;
                                }
                                if (lineChars.length < (charsOnThisLine = (actualEnd = text.charAt(lineEndIndex - 1) == '\r' ? lineEndIndex - 1 : lineEndIndex) - lineStartIndex)) {
                                    lineChars = new char[charsOnThisLine];
                                }
                                text.getChars(lineStartIndex, actualEnd, lineChars, 0);
                                pg.drawChars(lineChars, 0, charsOnThisLine, leftMargin, linePositionInY);
                                if (currentChar == '\n') {
                                    // empty if block
                                }
                                lineStartIndex = ++lineEndIndex;
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            int actualEnd = text.charAt(lineEndIndex - 1) == '\r' ? lineEndIndex - 1 : lineEndIndex;
                            charsOnThisLine = actualEnd - lineStartIndex;
                            if (lineChars.length < charsOnThisLine) {
                                lineChars = new char[charsOnThisLine];
                            }
                            text.getChars(lineStartIndex, actualEnd, lineChars, 0);
                            pg.drawChars(lineChars, 0, charsOnThisLine, leftMargin, linePositionInY);
                            pg.dispose();
                            break;
                        }
                        pg.dispose();
                        Font f = pg.getFont();
                        pg = pjob.getGraphics();
                        pg.setFont(f);
                    }
                    pjob.end();
                }
                catch (Throwable t) {
                    JavaAnalysisStudio.getApp().error("Error.  Print job canceled.", t);
                    pjob.end();
                }
            }
        }

        private PrintStream getCompilerPrintStream() {
            return new PrintStream(JavaAnalysisStudio.getApp().getOutputStream("Compiler Messages"));
        }

        public void onCompile() throws JASException, IOException {
            block16: {
                if (ProgramPage.this.f == null) {
                    throw new JASException("You must save the file before compiling it");
                }
                JavaAnalysisStudio app = JavaAnalysisStudio.getApp();
                String compiler = app.getUserProperties().getString("Compiler", "javac");
                boolean builtInCompiler = app.getUserProperties().getBoolean("UseBuiltInCompiler", true);
                if (builtInCompiler || !compiler.startsWith("javac") || !app.getUserProperties().getBoolean("ShowJDKWarningBox", true) || new JDKMessageBox(app.getFrame()).doModal()) {
                    File rt;
                    String jcp;
                    if (ProgramPage.this.isChanged) {
                        this.onSave();
                    }
                    char delimiter = File.pathSeparatorChar;
                    StringBuffer cp = new StringBuffer(System.getProperty("java.class.path"));
                    String ecp = app.getExtensionLoader().getClassPath().toString();
                    if (ecp.length() > 0) {
                        cp.append(delimiter).append(ecp);
                    }
                    if ((jcp = JASClassPath.create().toString()).length() > 0) {
                        cp.append(delimiter).append(jcp);
                    }
                    if ((rt = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar")).exists()) {
                        cp.append(delimiter).append(rt.getCanonicalPath());
                    }
                    String fpath = ProgramPage.this.f.getCanonicalPath();
                    if (!builtInCompiler) {
                        if (fpath.indexOf(32) > -1) {
                            fpath = "\"" + fpath + "\"";
                        }
                        String[] envP = new String[]{"CLASSPATH=" + cp};
                        String command = compiler + " " + fpath;
                        PrintStream out = this.getCompilerPrintStream();
                        out.println("----------- " + command);
                        Process p = Runtime.getRuntime().exec(command, envP);
                        CompileOutputProcessor t1 = new CompileOutputProcessor(p.getInputStream(), out);
                        CompileOutputProcessor t2 = new CompileOutputProcessor(p.getErrorStream(), out);
                        try {
                            int rc = p.waitFor();
                            t1.join();
                            t2.join();
                            out.println("----------- compile complete rc=" + rc);
                            if (rc > 0) {
                                app.error("Compile failed rc=" + rc + " (see Compiler Output window for details)");
                                break block16;
                            }
                            app.getToolkit().beep();
                            this.reload();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        try {
                            PrintStream out = this.getCompilerPrintStream();
                            out.println("----------- Compiling " + fpath);
                            BuiltInCompiler bic = new BuiltInCompiler(out);
                            bic.setClassPath(cp.toString());
                            boolean ok = bic.compile(fpath);
                            if (ok) {
                                out.println("----------- compile successful");
                                app.getToolkit().beep();
                                this.reload();
                            } else {
                                out.println("----------- compile failed");
                                app.error("Compile failed (see Compiler Output window for details)");
                            }
                        }
                        catch (Exception x) {
                            app.error("Unable to create built-in compiler", x);
                        }
                    }
                }
            }
        }

        private void reload() {
            JavaAnalysisStudio app = JavaAnalysisStudio.getApp();
            try {
                JASJob job = app.getJob();
                if (job != null) {
                    job.reload();
                }
                ProgramPage.this.m_isCompiled = true;
            }
            catch (LoaderException x) {
                app.error("Error reloading programs", x);
            }
            catch (RemoteException x) {
                app.error("Unexpected Exception", x);
            }
        }

        public void onCut() {
            ProgramPage.this.text.cut();
        }

        public void onCopy() {
            ProgramPage.this.text.copy();
        }

        public void onPaste() {
            ProgramPage.this.text.paste();
        }

        public void enableCut(JASState state) {
            state.setEnabled(ProgramPage.this.text.getSelectedText() != null);
        }

        public void enableCopy(JASState state) {
            state.setEnabled(ProgramPage.this.text.getSelectedText() != null);
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }

        private class JDKMessageBox
        extends JASDialog {
            private JCheckBox cb;

            JDKMessageBox(Frame f) {
                super(f, "Compile requirements", true, 13);
                Container c = this.getContentPane();
                c.setLayout(new BoxLayout(c, 1));
                c.add(new JLabel("Note:"));
                c.add(new JLabel("This option will not run unless you have"));
                c.add(new JLabel("downloaded the Java Development Kit from Sun."));
                this.cb = new JCheckBox("Show this message next time", true);
                c.add(this.cb);
                this.pack();
                this.setHelpTopic("jobs.eventAnalysisAndGeneration.compiling");
            }

            @Override
            public void onOK() {
                super.onOK();
                JavaAnalysisStudio.getApp().getUserProperties().setBoolean("ShowJDKWarningBox", this.cb.isSelected());
            }
        }
    }
}

