/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.interfaces.JavaDataServer;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASJobAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.JASWizardPage;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class ListJobPage
extends JASWizardPage
implements Finishable,
HasHelpPage {
    private JavaDataServer m_jds;
    private JTable m_table;
    private String[][] m_data;
    private JScrollPane m_scroll;
    private JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();

    ListJobPage() {
        super(new BorderLayout());
        this.add("North", new JLabel("Select job to connect to:"));
        this.m_table = new JTable();
        this.m_table.setAutoResizeMode(0);
        this.m_scroll = new JScrollPane(this.m_table);
        this.m_scroll.setPreferredSize(new Dimension(300, 150));
        this.add("Center", this.m_scroll);
    }

    public void setJDS(JavaDataServer jds) throws RemoteException {
        this.m_jds = jds;
        String[] m_jobs = jds.listJobs();
        this.m_data = new String[m_jobs.length][];
        for (int i = 0; i < m_jobs.length; ++i) {
            StringTokenizer token = new StringTokenizer(m_jobs[i], "\\");
            String[] result = new String[token.countTokens()];
            int j = 0;
            while (token.hasMoreTokens()) {
                result[j] = token.nextToken();
                ++j;
            }
            this.m_data[i] = result;
        }
    }

    @Override
    public void beforeShowing() {
        this.m_table.setModel(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ListJobPage.this.m_data.length - 1;
            }

            @Override
            public int getColumnCount() {
                return ListJobPage.this.m_data[0].length;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return ListJobPage.this.m_data[row + 1][column];
            }

            @Override
            public String getColumnName(int column) {
                return ListJobPage.this.m_data[0][column];
            }
        });
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JButton b;
                if (e.getClickCount() == 2 && (b = ListJobPage.this.getRootPane().getDefaultButton()) != null) {
                    b.doClick();
                }
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListJobPage.this.doEnable();
            }
        });
    }

    @Override
    protected void doEnable() {
        super.doEnable();
    }

    @Override
    protected boolean getFinishEnabled() {
        return !this.m_table.getSelectionModel().isSelectionEmpty();
    }

    @Override
    public String getHelpTopic() {
        return "Connect";
    }

    @Override
    public void onFinish() {
        int index = this.m_table.getSelectionModel().getLeadSelectionIndex();
        String entry = this.m_data[index + 1][0];
        String name = this.m_data[index + 1][1];
        JASJob jasJob = new JASJob(name);
        try {
            JASJobAdaptor job = new JASJobAdaptor(jasJob, entry, this.m_jds, this);
            this.m_app.closeCurrentJob();
            jasJob.setJob(job);
            this.m_app.setJob(jasJob, true);
            job.listItems();
            this.dispose();
        }
        catch (Exception e) {
            this.m_app.error("Could not connect to job", e);
        }
    }
}

