/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.SliceParameters;
import jas2.jds.interfaces.RemoteSliceInfo;
import jas2.jds.interfaces.RemoteSliceParameters;
import java.rmi.RemoteException;

class JASSliceAdaptor
implements SliceParameters {
    private boolean cacheValid = false;
    RemoteSliceInfo info;
    private RemoteSliceParameters m_remote;

    JASSliceAdaptor(RemoteSliceParameters remote) {
        this.m_remote = remote;
    }

    @Override
    public double getX() {
        if (!this.cacheValid) {
            this.setCache();
        }
        return this.info.x;
    }

    @Override
    public double getY() {
        if (!this.cacheValid) {
            this.setCache();
        }
        return this.info.y;
    }

    @Override
    public double getWidth() {
        if (!this.cacheValid) {
            this.setCache();
        }
        return this.info.width;
    }

    @Override
    public double getHeight() {
        if (!this.cacheValid) {
            this.setCache();
        }
        return this.info.height;
    }

    @Override
    public double getPhi() {
        if (!this.cacheValid) {
            this.setCache();
        }
        return this.info.phi;
    }

    @Override
    public void setX(double x) {
        try {
            this.m_remote.setX(x);
            this.cacheValid = false;
        }
        catch (RemoteException e) {
            System.err.println(e);
        }
    }

    @Override
    public void setY(double y) {
        try {
            this.m_remote.setY(y);
            this.cacheValid = false;
        }
        catch (RemoteException x) {
            System.err.println(x);
        }
    }

    @Override
    public void setWidth(double width) {
        try {
            this.m_remote.setWidth(width);
            this.cacheValid = false;
        }
        catch (RemoteException x) {
            System.err.println(x);
        }
    }

    @Override
    public void setHeight(double height) {
        try {
            this.m_remote.setHeight(height);
            this.cacheValid = false;
        }
        catch (RemoteException x) {
            System.err.println(x);
        }
    }

    @Override
    public void setPhi(double phi) {
        try {
            this.m_remote.setPhi(phi);
            this.cacheValid = false;
        }
        catch (RemoteException x) {
            System.err.println(x);
        }
    }

    private void setCache() {
        try {
            this.cacheValid = true;
            this.info = this.m_remote.getInfo();
        }
        catch (RemoteException x) {
            System.err.println(x);
        }
    }
}

