/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.module.LocalDIM;
import jas2.plugin.ExtensionPluginContext;
import jas2.plugin.PageContext;
import jas2.plugin.PageEvent;
import jas2.plugin.PageListener;
import jas2.swingstudio.JASRegistry;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.WindowManager;
import jas2.util.JASWizardPage;
import java.awt.Component;
import java.io.PrintWriter;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class JASPluginContext
implements ExtensionPluginContext {
    private JavaAnalysisStudio m_appl;

    JASPluginContext(JavaAnalysisStudio app) {
        this.m_appl = app;
    }

    @Override
    public void addMenu(JMenu menu) {
        JMenuBar menuBar = this.m_appl.getMenuBar();
        menuBar.add((Component)menu, menuBar.getComponentCount() - 1);
        menuBar.revalidate();
    }

    @Override
    public void removeMenu(JMenu menu) {
        JMenuBar menuBar = this.m_appl.getMenuBar();
        menuBar.remove(menu);
        menuBar.revalidate();
    }

    @Override
    public void error(String message) {
        this.m_appl.error(message);
    }

    @Override
    public void error(String message, Throwable detail) {
        this.m_appl.error(message, detail);
    }

    @Override
    public void sendMessage(String message) {
        this.m_appl.setMessage(message);
    }

    @Override
    public PrintWriter getPrintStream() {
        return new PrintWriter(this.m_appl.getOutputStream("Plugin Messages"));
    }

    @Override
    public void registerDIM(LocalDIM dim) {
        JASRegistry.registerDIM(dim);
    }

    @Override
    public void registerJobType(String name, JASWizardPage wizardPage) {
        JASRegistry.registerJobType(name, wizardPage);
    }

    @Override
    public boolean isApplet() {
        return false;
    }

    @Override
    public PageContext installControl(String name, Component page) {
        return new TabbedPanePageContext(this.m_appl.getControlPane(), name, page);
    }

    @Override
    public PageContext installConsole(String name, Component page) {
        return new TabbedPanePageContext(this.m_appl.getConsolePane(), name, page);
    }

    @Override
    public PageContext installPage(final String name, final Component page) {
        this.m_appl.getWindowManager().newWindow(name, page);
        return new PageContext(){

            @Override
            public final void addPageListener(PageListener pageListener) {
                WindowManager wm = JASPluginContext.this.m_appl.getWindowManager();
                wm.addPageListener(page, pageListener, this);
            }

            @Override
            public final void removePageListener(PageListener pageListener) {
                WindowManager wm = JASPluginContext.this.m_appl.getWindowManager();
                wm.removePageListener(pageListener);
            }

            @Override
            public final void requestShow() {
                WindowManager wm = JASPluginContext.this.m_appl.getWindowManager();
                int index = wm.find(page);
                if (index >= 0) {
                    wm.selectWindow(index);
                }
            }

            @Override
            public final void close() {
                WindowManager wm = JASPluginContext.this.m_appl.getWindowManager();
                int index = wm.find(page);
                if (index >= 0) {
                    wm.closeWindow(index);
                }
            }

            @Override
            public final String getPageName() {
                return name;
            }

            @Override
            public final Component getPage() {
                return page;
            }
        };
    }

    private static class TabbedPanePageContext
    implements PageContext,
    ChangeListener {
        private boolean isSelected = false;
        private JTabbedPane pane;
        private Component comp;
        private String name;
        private EventListenerList listeners = new EventListenerList();

        TabbedPanePageContext(JTabbedPane pane, String name, Component comp) {
            this.pane = pane;
            this.comp = comp;
            this.name = name;
            pane.addChangeListener(this);
            pane.addTab(name, comp);
            pane.setSelectedComponent(comp);
        }

        @Override
        public void addPageListener(PageListener pageListener) {
            this.listeners.add(PageListener.class, pageListener);
        }

        @Override
        public void removePageListener(PageListener pageListener) {
            this.listeners.remove(PageListener.class, pageListener);
        }

        @Override
        public void requestShow() {
            this.pane.setSelectedComponent(this.comp);
        }

        @Override
        public void close() {
            this.pane.remove(this.comp);
            this.firePageEvent(4001);
            this.pane.removeChangeListener(this);
            this.listeners = null;
        }

        @Override
        public Component getPage() {
            return this.comp;
        }

        @Override
        public String getPageName() {
            return this.name;
        }

        private void firePageEvent(int id) {
            PageEvent event = null;
            Object[] listener = this.listeners.getListenerList();
            for (int i = 0; i < listener.length; i += 2) {
                if (listener[i] != PageListener.class) continue;
                if (event == null) {
                    event = new PageEvent(this, id);
                }
                ((PageListener)listener[i + 1]).pageChanged(event);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selected = this.pane.getSelectedComponent();
            if (selected == this.comp && !this.isSelected) {
                this.firePageEvent(3999);
            }
            if (selected != this.comp && this.isSelected) {
                this.firePageEvent(4000);
            }
            this.isSelected = selected == this.comp;
        }
    }
}

