/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.JASHist;
import jas2.hist.JASHistAxis;
import jas2.hist.JASHistData;
import jas2.hist.SaveAsDialog;
import jas2.hist.VectorGraphicsTransferable;
import jas2.job.PageAccess;
import jas2.job.PlotAccess;
import jas2.plot.HasPopupItems;
import jas2.plot.PrintHelper;
import jas2.swingstudio.ChangableContainer;
import jas2.swingstudio.Closable;
import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeData;
import jas2.util.CommandProcessor;
import jas2.util.JASMenuItem;
import jas2.util.JASState;
import jas2.util.layout.PercentLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class JASPage
extends JPanel
implements HasCommandProcessor,
ChangableContainer,
HasPopupItems,
Closable {
    private boolean isPrinting = false;
    private boolean isPainting = false;
    private Vector m_plots;
    private Border border = new PageBorder();
    private JASHist currentPlot;
    private PageCommandProcessor commandProcessor = new PageCommandProcessor();
    private static JavaAnalysisStudio jas = JavaAnalysisStudio.getApp();
    private MouseListener ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JASHist newPlot = (JASHist)e.getSource();
            if (JASPage.this.currentPlot != newPlot) {
                JASPage.this.currentPlot.deselected();
                JASPage.this.currentPlot.repaint();
                JASPage.this.currentPlot = newPlot;
                JASPage.this.currentPlotChanged();
                JASPage.this.currentPlot.repaint();
            }
        }
    };

    public JASPage(PageAccess page) {
        this.setBackground(Color.white);
        int n = page.getNPlots();
        if (n > 0) {
            boolean constained = page.getPlot(0).isConstrained();
            if (constained) {
                this.setLayout(new PercentLayout());
            } else {
                this.setLayout(n);
            }
            this.m_plots = new Vector(n);
            for (int i = 0; i < n; ++i) {
                PlotAccess plot = page.getPlot(i);
                JASHist hist = new JASHist();
                int nHists = plot.getNDataSources();
                for (int j = 0; j < nHists; ++j) {
                    hist.addData(plot.getData(j)).show(true);
                }
                JASPage.calculateTitlesAndLabels(hist);
                hist.setBorder(this.border);
                hist.addMouseListener(this.ml);
                this.m_plots.addElement(hist);
                if (plot.isConstrained()) {
                    PercentLayout.Constraint constraint = new PercentLayout.Constraint(plot.getX(), plot.getY(), plot.getWidth(), plot.getHeight());
                    this.add((Component)hist, constraint);
                } else {
                    this.add(hist);
                }
                this.currentPlot = hist;
            }
        } else {
            this.setLayout(1);
            this.m_plots = new Vector();
            this.currentPlot = this.addPlotToPage();
        }
        this.currentPlotChanged();
    }

    public JASPage(int nx, int ny) {
        this.setBackground(Color.white);
        this.setLayout(new GridLayout(nx, ny));
        this.m_plots = new Vector(nx * ny);
        for (int i = 0; i < nx * ny; ++i) {
            this.currentPlot = this.addPlotToPage();
        }
        this.currentPlotChanged();
    }

    private JASHist addPlotToPage() {
        JASHist hist = new JASHist();
        hist.setBorder(this.border);
        hist.addMouseListener(this.ml);
        this.m_plots.addElement(hist);
        this.add(hist);
        return hist;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isOpaque() && !this.isPrinting && !PrintHelper.isPrinting()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void paint(Graphics g) {
        this.isPainting = true;
        super.paint(g);
        this.isPainting = false;
    }

    @Override
    public void print(Graphics g) {
        this.isPrinting = true;
        super.print(g);
        this.isPrinting = false;
    }

    public void addPlot() {
        this.setLayout(this.m_plots.size() + 1);
        this.currentPlot = this.addPlotToPage();
        this.currentPlotChanged();
        this.commandProcessor.setChanged();
        this.validate();
    }

    private void removePlot() {
        this.remove(this.currentPlot);
        this.m_plots.removeElement(this.currentPlot);
        this.currentPlot.removeMouseListener(this.ml);
        this.currentPlot.destroy();
        this.currentPlot = (JASHist)this.m_plots.elementAt(0);
        this.currentPlotChanged();
        this.setLayout(this.m_plots.size());
        this.validate();
    }

    private void setLayout(int n) {
        int nx;
        int ny;
        if (n == 1) {
            ny = 1;
            nx = 1;
        } else if (n == 2) {
            nx = 2;
            ny = 1;
        } else if (n == 3) {
            nx = 3;
            ny = 1;
        } else if (n == 4) {
            nx = 2;
            ny = 2;
        } else if (n <= 6) {
            nx = 3;
            ny = 2;
        } else if (n <= 9) {
            nx = 3;
            ny = 3;
        } else if (n <= 12) {
            nx = 4;
            ny = 3;
        } else if (n <= 16) {
            nx = 4;
            ny = 4;
        } else if (n <= 20) {
            nx = 5;
            ny = 4;
        } else if (n <= 25) {
            nx = 5;
            ny = 5;
        } else {
            throw new IllegalArgumentException("Too many plots on page");
        }
        LayoutManager layout = this.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
        }
        GridLayout grid = new GridLayout();
        this.setLayout(grid);
        if (nx != grid.getColumns()) {
            grid.setColumns(nx);
        }
        if (ny != grid.getRows()) {
            grid.setRows(ny);
        }
    }

    @Override
    public boolean pleaseClose() {
        Enumeration e = this.m_plots.elements();
        while (e.hasMoreElements()) {
            JASHist plot = (JASHist)e.nextElement();
            plot.removeMouseListener(this.ml);
            plot.destroy();
        }
        return true;
    }

    @Override
    public void pageSelected(boolean state) {
        if (state) {
            this.currentPlotUpdated();
        } else {
            jas.setRebinModel(null, null);
        }
    }

    @Override
    public CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public JASHist getCurrentPlot() {
        return this.currentPlot;
    }

    public void currentPlotUpdated() {
        this.currentPlotChanged();
    }

    private void currentPlotChanged() {
        JASHistAxis yAxis;
        DefaultBoundedRangeModel xRange = null;
        DefaultBoundedRangeModel yRange = null;
        final JASHistAxis xAxis = this.currentPlot.getXAxis();
        if (xAxis.isBinned() && !xAxis.isFixed()) {
            xRange = new DefaultBoundedRangeModel(xAxis.getBins(), 0, 1, Math.max(200, 2 * xAxis.getBins())){

                @Override
                public void fireStateChanged() {
                    xAxis.setBins(this.getValue());
                    super.fireStateChanged();
                }
            };
        }
        if ((yAxis = this.currentPlot.getYAxis()).isBinned() && !yAxis.isFixed()) {
            yRange = new DefaultBoundedRangeModel(yAxis.getBins(), 0, 1, Math.max(200, 2 * yAxis.getBins())){

                @Override
                public void fireStateChanged() {
                    yAxis.setBins(this.getValue());
                    super.fireStateChanged();
                }
            };
        }
        jas.setRebinModel(xRange, yRange);
        this.commandProcessor.setChanged();
    }

    @Override
    public boolean hasChanged() {
        Enumeration e = this.m_plots.elements();
        while (e.hasMoreElements()) {
            if (!((JASHist)e.nextElement()).isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        menu.add(new JASMenuItem("Remove Plot", 'R'));
        menu.add(new JASMenuItem("Print Page...", 'P'));
    }

    public static void calculateTitlesAndLabels(JASHist plot) {
        int n;
        if (plot.getNumberOfDataSources() == 0) {
            return;
        }
        String[][] titles = new String[plot.getNumberOfDataSources()][];
        Enumeration e = plot.getDataSources();
        int minLength = Integer.MAX_VALUE;
        for (n = 0; n < titles.length; ++n) {
            JASHistData data = (JASHistData)e.nextElement();
            titles[n] = data.getDataSource() instanceof TreeData ? ((TreeData)((Object)data.getDataSource())).getItem().path : new String[]{data.getTitle()};
            minLength = Math.min(minLength, titles[n].length);
        }
        boolean[] indeces = new boolean[minLength];
        for (int j = 0; j < minLength; ++j) {
            String titleCand = titles[0][j];
            boolean allSame = true;
            for (int k = 1; k < n; ++k) {
                if (titleCand.equals(titles[k][j])) continue;
                allSame = false;
                break;
            }
            indeces[j] = allSame;
        }
        StringBuffer title = new StringBuffer();
        for (int j = 0; j < minLength; ++j) {
            if (!indeces[j] || j == 0 && titles[0][0].equals("Histograms")) continue;
            if (title.length() > 0) {
                title.append(" - ");
            }
            title.append(titles[0][j]);
        }
        plot.setTitle(title.toString());
        e = plot.getDataSources();
        int k = 0;
        while (e.hasMoreElements()) {
            JASHistData data = (JASHistData)e.nextElement();
            StringBuffer legend = new StringBuffer();
            for (int j = 0; j < titles[k].length; ++j) {
                if (j < minLength && indeces[j]) continue;
                if (legend.length() > 0) {
                    legend.append(" - ");
                }
                legend.append(titles[k][j]);
            }
            data.setLegendText(legend.toString());
            ++k;
        }
    }

    private class PageCommandProcessor
    extends JASCommandProcessor {
        private PageCommandProcessor() {
        }

        public void onPrint() throws Exception {
            PrintHelper ph = PrintHelper.instance();
            ph.printTarget(JASPage.this);
        }

        public void onPrintPage() throws Exception {
            PrintHelper ph = PrintHelper.instance();
            ph.printTarget(JASPage.this);
        }

        public void onProperties() {
            JASPage.this.currentPlot.showProperties();
        }

        public void enableProperties(JASState state) {
            state.setEnabled(JASPage.this.currentPlot.supportsProperties());
        }

        public void onSaveAs() throws IOException {
            SaveAsDialog dlg = new SaveAsDialog(JASPage.this);
        }

        public void onCopy() {
            VectorGraphicsTransferable t = new VectorGraphicsTransferable(JASPage.this);
            JASPage.this.getToolkit().getSystemClipboard().setContents(t, t);
        }

        public void onRemovePlot() {
            JASPage.this.removePlot();
            this.setChanged();
        }

        public void enableRemovePlot(JASState state) {
            state.setEnabled(JASPage.this.m_plots.size() > 1);
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }

    private class PageBorder
    extends AbstractBorder {
        private PageBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!JASPage.this.isPrinting && JASPage.this.isPainting && !PrintHelper.isPrinting()) {
                g.setColor(c == JASPage.this.currentPlot ? Color.blue : JASPage.this.getBackground());
                g.drawRect(x, y, width - 1, height - 1);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }
    }
}

