/*
 * Decompiled with CFR 0.152.
 */
package jas2.plot;

import jas2.plot.AxisLabel;
import jas2.plot.AxisType;
import jas2.plot.CoordinateTransformation;
import jas2.plot.PlotGraphics;
import jas2.plot.TimeCoordinateTransformation;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class TimeAxis
extends AxisType
implements TimeCoordinateTransformation {
    public static final int MILLISECONDS = 0;
    public static final int SECONDS = 1;
    public static final int MINUTES = 2;
    public static final int HOURS = 3;
    public static final int DAYS = 4;
    public static final int WEEKS = 5;
    public static final int MONTHS = 6;
    public static final int YEARS = 7;
    public static final long OMIT = 0L;
    private long[] unitLengths = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L, 0L, 31536000000L};
    private final String[] unitNames = new String[]{"milliseconds", "seconds", "minutes", "hours", "days", "weeks", "months", "years"};
    private boolean useSuggestedRange = false;
    private int unitIndex;
    private long dataMin;
    private long dataMax;
    private long axisMin;
    private long axisMax;
    private AxisLabel[] labels;
    private final int majorTickLength = 5;
    private final int minSpaceBetweenLabels = 4;
    private final int maxCharsPerLabel = 6;

    public void setUnitLength(int unit, long length) {
        if (length < 0L || length != 0L && (unit != 0 && length <= this.unitLengths[unit - 1] || unit != 7 && length >= this.unitLengths[unit + 1])) {
            throw new IllegalArgumentException();
        }
        if (length == 0L && this.unitIndex == unit) {
            this.labelsValid = false;
        }
        this.unitLengths[unit] = length;
    }

    public long getUnitLength(int unit) {
        return this.unitLengths[unit];
    }

    public String getUnits() {
        return this.unitNames[this.unitIndex];
    }

    public void setUseSuggestedRange(boolean useSuggestedRange) {
        if (this.useSuggestedRange != useSuggestedRange) {
            this.labelsValid = false;
        }
        this.useSuggestedRange = useSuggestedRange;
    }

    public void setMin(long min) {
        if (this.dataMin != min) {
            this.labelsValid = false;
        }
        this.dataMin = min;
    }

    public void setMax(long max) {
        if (this.dataMax != max) {
            this.labelsValid = false;
        }
        this.dataMax = max;
    }

    public long getAxisMin() {
        return this.axisMin;
    }

    public long getAxisMax() {
        return this.axisMax;
    }

    public long getDataMin() {
        return this.dataMin;
    }

    public long getDataMax() {
        return this.dataMax;
    }

    @Override
    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    @Override
    void paintAxis(PlotGraphics g, double originX, double originY, double axisLength, Color textColor, Color majorTickColor, Color minorTickColor) {
        FontMetrics fm = g.getFontMetrics();
        if (this.axis.getAxisOrientation() == 2) {
            double y = originY + (double)fm.getMaxAscent() + 7.0;
            for (int i = 0; i < this.labels.length; ++i) {
                String text = this.labels[i].text;
                double x = originX + this.labels[i].position * axisLength;
                g.setColor(textColor);
                g.drawString(text, x - (double)(fm.stringWidth(text) / 2), y);
                g.setColor(majorTickColor);
                g.drawLine(x, originY + 5.0, x, originY - 5.0);
            }
        } else {
            double x = this.axis.onLeftSide ? originX - 7.0 : originX + 7.0;
            double height = fm.getAscent() / 2;
            for (int i = 0; i < this.labels.length; ++i) {
                String text = this.labels[i].text;
                double y = originY - this.labels[i].position * axisLength;
                g.setColor(textColor);
                g.drawString(text, this.axis.onLeftSide ? x - (double)fm.stringWidth(text) : x, y + height);
                g.setColor(majorTickColor);
                g.drawLine(originX - 5.0, y, originX + 5.0, y);
            }
        }
    }

    @Override
    void assumeAxisLength(int axisLength) {
        Font font = this.axis.getFont();
        FontMetrics fm = this.axis.getToolkit().getFontMetrics(font);
        int maxNumberOfDivisions = this.getMaxNumberOfDivisions(fm, axisLength);
        if (!this.labelsValid || this.labels == null || this.labels.length > maxNumberOfDivisions || this.labels.length < maxNumberOfDivisions / 2) {
            this.createNewLabels(maxNumberOfDivisions);
        }
        if (this.axis.getAxisOrientation() == 1) {
            this.spaceRequirements.width = this.longestStringLength(fm, this.labels) + 7;
            this.spaceRequirements.height = Math.max(fm.getAscent() / 2 - (int)(this.labels[0].position * (double)axisLength), 0);
            this.spaceRequirements.flowPastEnd = Math.max(fm.getMaxAscent() - fm.getAscent() / 2 - (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)axisLength), 0);
        } else {
            this.spaceRequirements.width = Math.max(fm.stringWidth(this.labels[0].text) / 2 - (int)(this.labels[0].position * (double)axisLength), 0);
            this.spaceRequirements.height = fm.getMaxAscent() + 7;
            this.spaceRequirements.flowPastEnd = Math.max(fm.stringWidth(this.labels[this.labels.length - 1].text) / 2 - (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)axisLength), 0);
        }
    }

    @Override
    int getMajorTickMarkLength() {
        return 5;
    }

    private void createNewLabels(int maxNDivisions) {
        this.labelsValid = true;
        this.unitIndex = this.getUnitIndex((this.dataMax - this.dataMin) / (long)maxNDivisions);
        long clumpLength = this.getClumpSize((this.dataMax - this.dataMin) / this.unitLengths[this.unitIndex] / (long)maxNDivisions);
        this.axisMin = this.useSuggestedRange ? this.dataMin - this.dataMin % clumpLength : this.dataMin;
        this.axisMax = this.useSuggestedRange && this.dataMax % clumpLength != 0L ? this.dataMax + clumpLength - this.dataMax % clumpLength : this.dataMax;
        int nLabels = (int)((this.axisMax - this.axisMin) / clumpLength);
        if (this.useSuggestedRange || this.axisMin % clumpLength == 0L || this.axisMin % clumpLength > this.axisMax % clumpLength) {
            ++nLabels;
        }
        this.labels = new AxisLabel[nLabels];
        long labelValue = this.useSuggestedRange || this.axisMin % clumpLength == 0L ? this.axisMin : this.axisMin + clumpLength - this.axisMin % clumpLength;
        for (int i = 0; i < nLabels; ++i) {
            this.labels[i] = new AxisLabel();
            this.labels[i].text = String.valueOf(labelValue / this.unitLengths[this.unitIndex]);
            this.labels[i].position = (double)(labelValue - this.axisMin) / (double)(this.axisMax - this.axisMin);
            labelValue += clumpLength;
        }
        System.out.println("Labels are using units: ".concat(this.getUnits()));
    }

    private int getMaxNumberOfDivisions(FontMetrics fm, int axisLength) {
        int result = this.axis.getAxisOrientation() == 2 ? axisLength / (fm.charWidth('5') * 6 + 4) : axisLength / (fm.getHeight() + 4);
        return Math.max(2, result);
    }

    private int getUnitIndex(long minDivisionSpan) {
        minDivisionSpan *= 2L;
        int i = 0;
        int j = 0;
        while (i < this.unitLengths.length) {
            if (this.unitLengths[i] == 0L) {
                ++i;
                continue;
            }
            if (this.unitLengths[i] >= minDivisionSpan) break;
            j = i++;
        }
        return j;
    }

    private long getClumpSize(long naturalNumberInClump) {
        long[] typicalClumps = new long[]{1L, 2L, 5L, 10L, 20L, 25L, 50L, 100L, 200L};
        long mult = this.unitLengths[this.unitIndex];
        while (naturalNumberInClump > 100L) {
            naturalNumberInClump /= 100L;
            mult *= 100L;
        }
        int clumpIndex = 0;
        while (naturalNumberInClump >= typicalClumps[clumpIndex]) {
            ++clumpIndex;
        }
        return typicalClumps[clumpIndex] * mult;
    }

    @Override
    public double convert(long time) {
        int minL = this.axis.getMinLocation();
        int maxL = this.axis.getMaxLocation();
        float f = (float)(time - this.axisMin) / (float)(this.axisMax - this.axisMin);
        return (float)minL + f * (float)(maxL - minL);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.useSuggestedRange);
        out.writeObject(this.unitLengths);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.useSuggestedRange = in.readBoolean();
        this.unitLengths = (long[])in.readObject();
    }
}

