/*
 * Decompiled with CFR 0.152.
 */
package jas2.job;

import hepjas.analysis.Histogram;
import hepjas.analysis.NamedObject;
import hepjas.analysis.Partition;
import hepjas.analysis.partition.PartitionFactory;
import hepjas.analysis.peer.HistogramPeer;
import jas2.hep.PartitionAdapter;
import jas2.hist.DataSource;
import jas2.hist.HasSlices;
import jas2.hist.HistogramUpdate;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.hist.util.ScatterSliceAdapter;
import jas2.hist.util.SliceAdapter;
import jas2.hist.util.SliceEvent;
import jas2.hist.util.SliceListener;
import jas2.job.HistogramAccess;
import jas2.job.JobFolder;
import jas2.job.JobSlice;
import jas2.util.tree.SimpleNode;

final class JobHistogram
extends SimpleNode
implements HistogramPeer,
HistogramAccess {
    private static final HistogramUpdate hReset = new HistogramUpdate(16, true);
    private Histogram m_hist;

    public JobHistogram(Histogram hist, JobFolder parent) {
        super(parent, hist.getName(), "histogramAccess", 0, null);
        this.m_hist = hist;
    }

    @Override
    public void partitionNotify() {
        this.treeChanged(0x100000);
    }

    @Override
    public Object getObject() {
        return this;
    }

    public void clearPartition() {
        Partition p = this.m_hist.getPartition();
        if (p == null) {
            return;
        }
        p.destroy();
    }

    @Override
    public void delete() {
        this.m_hist.delete();
    }

    @Override
    public void clear() {
        Partition p = this.m_hist.getPartition();
        if (p != null) {
            p.clear();
        }
    }

    @Override
    public void show() {
        this.treeChanged(524288);
    }

    @Override
    public void rename(String newName) throws NamedObject.RenameException {
        this.m_hist.rename(newName);
        if (this.canSetClearOnRewind()) {
            this.setClearOnRewind(false);
        }
    }

    @Override
    public void setClearOnRewind(boolean clear) {
        this.m_hist.setClearOnRewind(clear);
    }

    @Override
    public boolean isClearOnRewind() {
        return this.m_hist.isClearOnRewind();
    }

    @Override
    public boolean canSetClearOnRewind() {
        SimpleNode parent = this.getParent();
        if (parent instanceof HistogramAccess) {
            HistogramAccess ha = (HistogramAccess)((Object)parent);
            return ha.isClearOnRewind() && ha.canSetClearOnRewind();
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.m_hist.toString();
    }

    @Override
    public DataSource getData() {
        Partition p = this.m_hist.getPartition();
        if (p instanceof PartitionFactory) {
            return null;
        }
        DataSource result = PartitionAdapter.create(p, this.m_hist.getName());
        if (result instanceof Rebinnable2DHistogramData && !(result instanceof HasSlices)) {
            result = new ScatterSliceAdapter((Rebinnable2DHistogramData)result);
        }
        if (result instanceof SliceAdapter) {
            ((SliceAdapter)((Object)result)).addSliceListener(new SliceListener(){

                @Override
                public void sliceAdded(SliceEvent e) {
                    HasSlices hs = (HasSlices)e.getSource();
                    Rebinnable1DHistogramData data = hs.getSlice(e.getIndex());
                    new JobSlice(data, JobHistogram.this);
                }

                @Override
                public void sliceRemoved(SliceEvent e) {
                    HasSlices hs = (HasSlices)e.getSource();
                    Rebinnable1DHistogramData data = hs.getSlice(e.getIndex());
                    SimpleNode slice = JobHistogram.this.findChild(data.getTitle());
                    slice.destroy();
                }
            });
        }
        return result;
    }
}

