/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist.test;

import jas2.hist.HasStyle;
import jas2.hist.JASHist;
import jas2.hist.JASHist1DHistogramStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.XYDataSource;
import javax.swing.JFrame;

public class XYTestData
implements XYDataSource,
HasStyle {
    private double[] x;
    private double[] y;

    public XYTestData() {
        int n = 100;
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = this.y[i] = (double)i / (double)n;
        }
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    @Override
    public String getTitle() {
        return "Test XY Data";
    }

    @Override
    public double getMinusError(int index) {
        return Math.sqrt(this.x[index]);
    }

    @Override
    public double getPlusError(int index) {
        return Math.sqrt(this.x[index]);
    }

    @Override
    public double getX(int index) {
        return this.x[index];
    }

    @Override
    public double getY(int index) {
        return this.y[index];
    }

    @Override
    public int getNPoints() {
        return this.x.length;
    }

    @Override
    public JASHistStyle getStyle() {
        JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();
        style.setShowHistogramBars(false);
        style.setShowDataPoints(true);
        style.setShowLinesBetweenPoints(true);
        style.setShowErrorBars(false);
        return style;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("XY Test");
        JASHist plot = new JASHist();
        plot.addData(new XYTestData()).show(true);
        frame.getContentPane().add(plot);
        frame.setSize(400, 400);
        frame.show();
    }
}

