/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.AbstractDataManager;
import jas2.hist.DataSource;
import jas2.hist.DataSourceMenuFactory;
import jas2.hist.HasSlices;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.ManagedAxis;
import jas2.hist.SliceOverlay;
import jas2.hist.SliceParameters;
import jas2.hist.StatisticsBlock;
import jas2.hist.SupportsSlices;
import jas2.plot.DataArea;
import jas2.plot.Legend;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

abstract class SliceableDataManager
extends AbstractDataManager
implements SupportsSlices {
    private Vector slices = new Vector();

    SliceableDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
    }

    @Override
    public void addSlice(SliceParameters sp) {
        SliceOverlay so = new SliceOverlay(sp);
        this.slices.addElement(so);
        this.da.add(so);
    }

    @Override
    public void removeAllSlices() {
        Enumeration e = this.slices.elements();
        while (e.hasMoreElements()) {
            SliceOverlay so = (SliceOverlay)e.nextElement();
            this.da.remove(so);
        }
        this.slices.removeAllElements();
    }

    @Override
    void destroy() {
        super.destroy();
        this.removeAllSlices();
        this.slices.removeAllElements();
    }

    @Override
    public void fillSliceMenu(JMenu menu) {
        menu.add(this.addPerDataSourceMenu("Add Slice/Projection", new DataSourceMenuFactory(){

            @Override
            public JMenu createMenu(String name, JASHistData ds) {
                return new SliceMenu(name, ds);
            }
        }));
        menu.add(this.addPerDataSourceMenu("Remove Slice/Projection", new DataSourceMenuFactory(){

            @Override
            public JMenu createMenu(String name, JASHistData ds) {
                return new RemoveSliceMenu(name, ds);
            }
        }));
    }

    @Override
    void modifyPopupMenu(JPopupMenu menu, Component source) {
        menu.add(this.addPerDataSourceMenu("Add Slice/Projection", new DataSourceMenuFactory(){

            @Override
            public JMenu createMenu(String name, JASHistData ds) {
                return new SliceMenu(name, ds);
            }
        }));
        menu.add(this.addPerDataSourceMenu("Remove Slice/Projection", new DataSourceMenuFactory(){

            @Override
            public JMenu createMenu(String name, JASHistData ds) {
                return new RemoveSliceMenu(name, ds);
            }
        }));
    }

    private final class RemoveSliceMenu
    extends JMenu {
        private HasSlices hasSlices;

        public RemoveSliceMenu(String name, JASHistData data) {
            super(name);
            DataSource ds = data.getDataSource();
            boolean slice = ds instanceof HasSlices && ((HasSlices)((Object)ds)).canAddRemoveSlices() && ((HasSlices)((Object)ds)).getNSlices() > 0;
            this.setEnabled(slice);
            if (slice) {
                this.hasSlices = (HasSlices)((Object)ds);
                this.add(new JMenuItem("Remove All"){

                    @Override
                    public void fireActionPerformed(ActionEvent e) {
                        SliceableDataManager.this.removeAllSlices();
                        int i = RemoveSliceMenu.this.hasSlices.getNSlices();
                        while (i > 0) {
                            RemoveSliceMenu.this.hasSlices.removeSlice(--i);
                        }
                    }
                });
            }
        }

        private class SliceItem
        extends JMenuItem {
            private int index;

            SliceItem(String name, int index) {
                super(name);
                this.index = index;
            }

            @Override
            public void fireActionPerformed(ActionEvent e) {
                RemoveSliceMenu.this.hasSlices.removeSlice(this.index);
            }
        }
    }

    private final class SliceMenu
    extends JMenu {
        private HasSlices hasSlices;

        public SliceMenu(String name, JASHistData data) {
            super(name);
            DataSource ds = data.getDataSource();
            boolean slice = ds instanceof HasSlices && ((HasSlices)((Object)ds)).canAddRemoveSlices();
            this.setEnabled(slice);
            if (slice) {
                this.hasSlices = (HasSlices)((Object)ds);
                this.add(new SliceItem("X Projection", 0.0));
                this.add(new SliceItem("Y Projection", 1.5707963267948966));
                this.add(new SliceItem("X Slice", SliceableDataManager.this.xm, SliceableDataManager.this.ym[0], 0.0));
                this.add(new SliceItem("Y Slice", SliceableDataManager.this.xm, SliceableDataManager.this.ym[0], 1.5707963267948966));
            }
        }

        private class SliceItem
        extends JMenuItem {
            private double phi;
            private double x;
            private double y;
            private double width;
            private double height;

            SliceItem(String name, double phi) {
                super(name);
                this.phi = phi;
                this.x = 0.0;
                this.y = 0.0;
                this.width = Double.POSITIVE_INFINITY;
                this.height = Double.POSITIVE_INFINITY;
            }

            SliceItem(String name, ManagedAxis x, ManagedAxis y, double phi) {
                super(name);
                this.phi = phi;
                this.x = (x.getMin() + x.getMax()) / 2.0;
                this.y = (y.getMin() + y.getMax()) / 2.0;
                if (phi == 0.0) {
                    this.width = (x.getMax() - x.getMin()) / 4.0;
                    this.height = (y.getMax() - y.getMin()) / 4.0;
                } else {
                    this.height = (x.getMax() - x.getMin()) / 4.0;
                    this.width = (y.getMax() - y.getMin()) / 4.0;
                }
            }

            @Override
            public void fireActionPerformed(ActionEvent e) {
                int n = SliceMenu.this.hasSlices.addSlice(this.x, this.y, this.width, this.height, this.phi);
                SliceableDataManager.this.addSlice(SliceMenu.this.hasSlices.getSliceParameters(n));
            }
        }
    }
}

