/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DataSource;
import jas2.hist.HistogramUpdate;
import jas2.hist.JASHist;
import jas2.hist.JASHist1DHistogramData;
import jas2.hist.JASHist1DHistogramStyle;
import jas2.hist.JASHistData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.SliceableDataManager;
import jas2.hist.StatisticsBlock;
import jas2.plot.DataArea;
import jas2.plot.Legend;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class OneDDataManager
extends SliceableDataManager {
    protected transient double xLow;
    protected transient double xHigh;

    OneDDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
    }

    @Override
    JASHistData add(DataSource ds) {
        JASHist1DHistogramData dw = new JASHist1DHistogramData(this, ds);
        this.data.addElement(dw);
        return dw;
    }

    @Override
    void modifyPopupMenu(JPopupMenu menu, Component source) {
        HistMenuItem outline = new HistMenuItem("Show Histogram Bars", "ShowHistogramBars");
        HistMenuItem fill = new HistMenuItem("Fill Histogram Bars", "HistogramFill");
        HistMenuItem error = new HistMenuItem("Show Error Bars", "ShowErrorBars");
        HistMenuItem lines = new HistMenuItem("Draw Lines Between Points", "ShowLinesBetweenPoints");
        HistMenuItem symbols = new HistMenuItem("Show Data Points", "ShowDataPoints");
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        menu.add(outline);
        menu.add(fill);
        menu.add(error);
        menu.add(lines);
        menu.add(symbols);
        if (fill.isEnabled()) {
            fill.setEnabled(outline.isSelected());
        }
    }

    @Override
    protected final void doUpdate() {
        if (this.isInit) {
            if (this.xm.needsAttention()) {
                this.computeXAxisRange();
                this.XAxisUpdated();
            }
            this.computeYAxisRange();
            this.stats.repaint();
            this.da.repaint();
        }
    }

    @Override
    public void update(HistogramUpdate hu, JASHistData data) {
        int index = data.getYAxis();
        if (hu.isRangeUpdate() || hu.isReset()) {
            this.xm.setAttentionNeeded();
        } else {
            this.ym[index].setAttentionNeeded();
        }
        if (hu.isFinalUpdate() || hu.isReset()) {
            SwingUtilities.invokeLater(this);
            if (hu.isReset()) {
                DataSource dataSource = data.getDataSource();
                boolean isRebinnable = dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)dataSource).isRebinnable() : false;
                this.xm.setFixed(!isRebinnable);
                this.xm.setRangeAutomatic(isRebinnable);
            }
        } else {
            this.timer.start();
        }
    }

    @Override
    final void axisChanged(JASHistData data) {
        int index = data.getYAxis();
        if (this.ym[index] == null) {
            this.createYAxis(index);
        } else {
            this.ym[index].setAttentionNeeded();
        }
        SwingUtilities.invokeLater(this);
    }

    @Override
    void styleUpdate(JASHistData data) {
        int index = data.getYAxis();
        if (this.ym[index] == null) {
            this.createYAxis(index);
        } else {
            this.ym[index].setAttentionNeeded();
        }
        SwingUtilities.invokeLater(this);
    }

    private final class HistMenuItem
    extends JCheckBoxMenuItem {
        private String m_methodRoot;

        HistMenuItem(String menuLabel, String methodRoot) {
            super(menuLabel);
            if (OneDDataManager.this.numberOfDataSources() > 0) {
                try {
                    this.m_methodRoot = methodRoot;
                    Method get = JASHist1DHistogramStyle.class.getMethod("get".concat(methodRoot), new Class[0]);
                    boolean selected = true;
                    Enumeration e = OneDDataManager.this.getDataSources();
                    Object[] emptyList = new Object[]{};
                    while (selected && e.hasMoreElements()) {
                        selected = (Boolean)get.invoke((Object)((JASHistData)e.nextElement()).getStyle(), emptyList);
                    }
                    this.setSelected(selected);
                }
                catch (NoSuchMethodException x) {
                    this.setEnabled(false);
                    this.setSelected(false);
                }
                catch (IllegalAccessException x) {
                    this.setEnabled(false);
                    this.setSelected(false);
                }
                catch (InvocationTargetException x) {
                    this.setEnabled(false);
                    this.setSelected(false);
                }
            } else {
                this.setEnabled(false);
                this.setSelected(false);
            }
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            Class[] booleanList = new Class[]{Boolean.TYPE};
            try {
                Method set = JASHist1DHistogramStyle.class.getMethod("set".concat(this.m_methodRoot), booleanList);
                Object[] arg = new Object[]{new Boolean(this.isSelected())};
                Enumeration enumer = OneDDataManager.this.getDataSources();
                while (enumer.hasMoreElements()) {
                    try {
                        set.invoke((Object)((JASHistData)enumer.nextElement()).getStyle(), arg);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

